package com.elitesland.fin.service.arorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.arorder.ArOrderRpcDTO;
import com.elitesland.fin.param.arorder.ArOrderPageRpcParam;
import com.elitesland.fin.param.arorder.ArOrderRecordRpcParam;
import com.elitesland.fin.param.arorder.ArOrderRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author wang.xl
 * @version V1.0
 * 应收单
 * @Package com.elitesland.fin.service.arorder
 * @date 2022/5/18 15:42
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + ArOrderRpcService.PATH)
public interface ArOrderRpcService {
    String PATH = "/arOrder";

    /**
     *
     * 目前订单未使用
     *
     */
    @PostMapping("/save")
    Long save(@RequestBody ArOrderRpcParam arOrderRpcParam);


    /**
     * 应收单列表查询
     */
    @PostMapping("/page")
    ApiResult<PagingVO<ArOrderRpcDTO>> page(@RequestBody ArOrderPageRpcParam arOrderPageRpcParam);


    /**
     * 自动生成应收单:命中配置项设置规则的业务单据则可以生成
     * <p>
     * 业务方提供公司，来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则，
     * 命中规则的数据按接口样式传输生成对应的应收单，状态是待审核；根据配置项判断是否自动审核。
     * 已生成应收单的业务单据需要打上标记ar_flag，1表示已经生成；0表示未生成。
     *（注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司）
     *
     * @param arOrderRecordRpcParam 入参
     * @return 出参
     */
    @PostMapping("/autoCreate")
    ApiResult<Void> autoCreate(@RequestBody ArOrderRecordRpcParam arOrderRecordRpcParam);

}
