package com.elitesland.fin.param.payorder;

import com.elitesland.fin.dto.payorder.PayOrderDtlRpcDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 10:36
 */
@Data
public class PayOrderRpcParam implements Serializable {
    @Serial
    private static final long serialVersionUID = -3556084242260987258L;

    @ApiModelProperty("来源系统单号")
    private String sourceNo;

    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司ID")
    private Long ouId;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty(value = "部门ID")
    private Long buId;
    @ApiModelProperty(value = "部门编码")
    private String buCode;
    @ApiModelProperty(value = "部门名称")
    private String buName;

    @ApiModelProperty("供应商ID")
    private Long suppId;
    @ApiModelProperty("供应商编码")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("经办人")
    private String operator;
    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("应付单类型定义ID")
    private Long apTypeId;
    @ApiModelProperty("应付单类型名称")
    private String apTypeName;
    @ApiModelProperty("应付单类型代码")
    private String apTypeCode;

    @ApiModelProperty("付款单类型ID")
    private Long payTypeId;
    @ApiModelProperty("付款单类型代码")
    private String payTypeCode;
    @ApiModelProperty("付款单类型名称")
    private String payTypeName;

    @ApiModelProperty(value = "单据来源", notes = "[UDC]yst-fin:PAY_DOC_CLS")
    private String createMode;

    @ApiModelProperty("本位币名称")
    private String localCurrCode;
    @ApiModelProperty("本位币编码")
    private String localCurrName;
    @ApiModelProperty("币种编码")
    private String currCode;
    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("业务类型")
    private String buType;
    private String buTypeName;
    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;
    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("预计付款日期")
    private LocalDateTime apDate;
    @ApiModelProperty("是否预付")
    private Boolean apFlag;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty(value = "付款方式", notes = "[UDC]yst-supp:PAY_METHOD")
    private String payType;
    @ApiModelProperty(value = "付款方开户银行")
    private String payBank;
    @ApiModelProperty(value = "付款方银行账户")
    private String payAccount;
    @ApiModelProperty(value = "收款方开户银行")
    private String recBank;
    @ApiModelProperty(value = "收款方银行账户")
    private String recAccount;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(value = "内外部客户", notes = "[UDC]yst-purc:IO_TYPE")
    private String inOutCust;
    @ApiModelProperty(value = "关联公司编码")
    private String relevanceOuCode;

    @ApiModelProperty("明细集合")
    private List<PayOrderDtlRpcDTO> payOrderDtlRpcDTOList;
}
