package com.elitesland.fin.service.invoice;

import com.elitesland.fin.Application;
import com.elitesland.fin.dto.invoice.InvoiceRuleConfigRpcDTO;
import com.elitesland.fin.param.invoice.InvoiceRuleConfigRpcParam;
import com.elitesland.fin.service.pay.PayRpcService;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author sunxw
 * @description 开票配置rpc
 * @Date 2023/7/17
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + PayRpcService.PATH)
public interface InvoiceRuleConfigRpcService {

    String PATH = "/invRule";

    @PostMapping("/getList")
    List<InvoiceRuleConfigRpcDTO> getInvRuleConfig(@RequestBody List<InvoiceRuleConfigRpcParam> param);

}
