package com.elitesland.fin.service.creditaccount;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.creditaccount.CreditAccountRpcDTO;
import com.elitesland.fin.param.creditaccount.CreditAccountRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.service.account
 * @date 2023/3/7 13:56
 */

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + CreditAccountRpcService.PATH)
public interface CreditAccountRpcService {

    String PATH = "/creditAccount";


    @PostMapping("/createCreditAccounts")
    ApiResult<Void> createCreditAccounts(@RequestBody List<CreditAccountRpcParam> param);

    @PostMapping("/createCreditAccount")
    ApiResult<Object> createCreditAccount(CreditAccountRpcParam param);

    @PostMapping("/queryCreditAccountCode")
    ApiResult<List<CreditAccountRpcDTO>> queryCreditAccountCode(@RequestBody CreditAccountRpcParam param);

    @PostMapping("/updateRelateAccount")
    ApiResult<Object> updateRelateAccount(@RequestBody List<CreditAccountRpcParam> params);

}
