package com.elitesland.fin.param.aporder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lucan.liu
 * @version V1.0
 * @Package com.elitesland.fin.param.aporder
 * @date 2023/7/28 14:22
 */
@Data
public class ApOrderPageRpcParam implements Serializable {
    private static final long serialVersionUID = -881848139556691291L;
    @ApiModelProperty(value = "来源系统编号")
    private String sourceNo;

    @ApiModelProperty(value = "应付单编号")
    private String apOrderNo;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "来源单据")
    private String createMode;

    @ApiModelProperty(value = "应付单类型定义ID")
    private Long apTypeId;

    @ApiModelProperty(value = "应付单类型名称")
    private String apTypeName;

    @ApiModelProperty(value = "应付单类型代码")
    private String apTypeCode;

    @ApiModelProperty(value = "单据状态")
    private String orderState;

    @ApiModelProperty(value = "业务日期/开始")
    private LocalDateTime buDateStart;

    @ApiModelProperty(value = "业务日期/结束")
    private LocalDateTime buDateEnd;

    @ApiModelProperty(value = "含税总金额/开始")
    private BigDecimal totalAmtStart;

    @ApiModelProperty(value = "含税总金额/结束")
    private BigDecimal totalAmtEnd;


    @ApiModelProperty(value = "币种编码")
    private String currCode;

    @ApiModelProperty(value = "币种")
    private String currName;

    @ApiModelProperty(value = "审核人ID")
    private Long auditUserId;

    @ApiModelProperty(value = "审核人")
    private String auditUser;

    @ApiModelProperty(value = "审核时间")
    private LocalDateTime auditDate;


    @ApiModelProperty(value = "经办人ID")
    private Long operUserId;

    @ApiModelProperty(value = "经办人")
    private String operator;


    @ApiModelProperty(value = "是否期初")
    private Boolean initFlag;


    @ApiModelProperty(value = "供应商ID")
    private Long suppId;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty(value = "创建人")
    private String creator;


    @ApiModelProperty("明细行来源单号")
    private String sourceNoDtl;

    @ApiModelProperty(value = "核销状态")
    private String verState;

}
