package com.elitesland.fin.dto.arorder;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/12 16:14
 */
@Data
public class ArOrderRpcDTO implements Serializable {

    private static final long serialVersionUID = 3885513784926932000L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("应收单编号")
    private String arOrderNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("含税金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("不含税金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核日期")
    private LocalDateTime auditDate;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否含税")
    private Boolean taxFlag;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("部门ID")
    private Long buId;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("部门名称")
    private String buName;

    @ApiModelProperty("业务类型")
    private String buType;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("组织ID")
    private Long orgId;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("单据类型")
    private String arOrderType;

    @ApiModelProperty("总数量")
    private Long totalCount;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("明细数据")
    private List<ArOrderDtlRpcDTO> dtlList;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;
}
