package com.elitesland.fin.service.paymentruleconfig;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigDtlRpcDTO;
import com.elitesland.fin.param.paymentruleconfig.PaymentRuleConfigRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author gyj
 * @date 2023/3/7 13:56
 */
@RestController
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PaymentRuleConfigRpcService.PATH)
public interface PaymentRuleConfigRpcService {

    String PATH = "rpc/paymentRule";

    /**
     * 查询账户金额
     */
    @PostMapping("/queryAccountAmount")
    ApiResult<List<PaymentRuleConfigDtlRpcDTO>> queryAccountAmount(@RequestBody PaymentRuleConfigRpcParam param);

    /**
     * 支付
     */
    @PostMapping("/pay")
    ApiResult<List<PaymentRuleConfigDtlRpcDTO>> pay(@RequestBody PaymentRuleConfigRpcParam param);

}
