package com.elitesland.fin.service.generateaccountflow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.generateaccountflow.GenerateAccountFlowRpcDTO;

import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author gyj
 * @date 2023/3/7 13:56
 */
@RestController
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + GenerateAccountFlowRpcService.PATH)
public interface GenerateAccountFlowRpcService {

    String PATH = "/generateAccountFlow";

    /**
     * 生成账户流水
     */
    @PostMapping("/generateAccountFlow")
    ApiResult<List<GenerateAccountFlowRpcDTO>> generateAccountFlow(@RequestBody List<GenerateAccountFlowRpcParam> param);

    /**
     * 生成账户流水 根据已经生成流水的来源单号再生成流水
     */
    @PostMapping("/generateFlow")
    ApiResult<List<GenerateAccountFlowRpcDTO>> generateFlow(@RequestBody GenerateAccountFlowRpcParam param);



}
