package com.elitesland.fin.param.arorder;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @version V1.0
 * @date 2023/8/1 16:01
 */
@Data
public class ArOrderPageRpcParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 7356019896853105505L;
    @ApiModelProperty("来源系统单号")
    private String sourceNo;

    @ApiModelProperty("应收单号")
    private String arOrderNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("来源单据")
    private String createMode;

    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("业务日期/开始")
    private LocalDateTime buDateStart;

    @ApiModelProperty("业务日期/结束")
    private LocalDateTime buDateEnd;

    @ApiModelProperty("含税金额/开始")
    private BigDecimal totalAmtStart;

    @ApiModelProperty("含税金额/结束")
    private BigDecimal totalAmtEnd;

    @ApiModelProperty("不含税金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核日期/开始")
    private LocalDateTime auditDateStart;

    @ApiModelProperty("审核日期/结束")
    private LocalDateTime auditDateEnd;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("经办人")
    private String operator;

    @ApiModelProperty("是否含税")
    private Boolean taxFlag;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("销售部门ID")
    private Long buId;

    @ApiModelProperty("销售部门编码")
    private String buCode;

    @ApiModelProperty("销售部门名称")
    private String buName;

    @ApiModelProperty("业务类型")
    private String buType;

    @ApiModelProperty("付款条件")
    private String payMent;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("明细行来源单号")
    private String sourceNoDtl;

    @ApiModelProperty(value = "销售组织ID")
    private Long orgId;

    @ApiModelProperty(value = "销售编码")
    private String orgCode;

    @ApiModelProperty(value = "销售名称")
    private String orgName;

    @ApiModelProperty(value = "销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty(value = "销售业务员")
    private String saleUser;

    @ApiModelProperty(value = "单据类型")
    private String arOrderType;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;
}
