package com.elitesland.fin.dto.account;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@ApiModel(value = "账户表",description = "账户表")
@Data
public class AccountRpcDTO implements Serializable {

    private static final long serialVersionUID = 6521122225836423706L;

    @ApiModelProperty("归属公司编码")
    private String secOuCode;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_TYPE")
    private String accountType;

    @ApiModelProperty("账户类型名称")
    private String accountTypeName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String state;
    private String stateName;

}