package com.elitesland.fin.param.aporder;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/11/04
 * @Version 1.0
 * @Content:
 */
@Data
public class ApOrderDtlHandleRpcParam implements Serializable {
    private static final long serialVersionUID = 7129758129651081741L;


    private Long masId;

    private String sourceNo;

    private Integer sourceLine;

    private Long itemId;

    private String itemCode;

    private String itemName;

    private String itemType;

    private String smallCateCode;

    private String smallCateName;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal exclTaxPrice;

    private BigDecimal price;

    private BigDecimal taxRate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String remark;

    private BigDecimal verAmt;

    private BigDecimal unVerAmt;

    private BigDecimal applyVerAmTing;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    private String creator;

    private Long sourceNoDid;

    private BigDecimal costPrice;

    @ApiModelProperty("应付暂估差异")
    private BigDecimal invoicePriceVariance;

    private String protocolCode;

    @ApiModelProperty("库存流水ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long invIoId;

    @ApiModelProperty("关联单号(对账单号)")
    private String relateDocNo;

    @ApiModelProperty(value = "关联单行号(对账单)")
    private Integer relateDocLine;
}
