package com.elitesland.fin.service.invoice;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.param.invoice.InvoiceAwaitSaveParam;
import com.elitesland.fin.service.pay.PayRpcService;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 开票申请
 * Created by lance on 2023/7/13.
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PayRpcService.PATH)
public interface InvoiceAwaitRpcService {

    String PATH = "/invoice/await";

    /**
     * 保存开票申请
     *
     * @param invoiceAwaitSaveParam
     * @return
     */
    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody InvoiceAwaitSaveParam invoiceAwaitSaveParam);

    /**
     * 生成付款记录并根据条件生成开票申请
     *
     * @param paymentRecordsSaveVOList
     * @return
     */
//    @PostMapping("/saveAndGenerateInvoice")
//    ApiResult<List<Long>> saveAndGenerateInvoice(@RequestBody List<PaymentRecordsSaveVO> paymentRecordsSaveVOList);
//
//
//    /**
//     * 订货单手动开票
//     *
//     * @param invApplySaveRpcDTO
//     * @return
//     */
//    @PostMapping("/generateInvoice")
//    ApiResult<List<Long>> generateInvoice(@RequestBody InvApplySaveRpcDTO invApplySaveRpcDTO);
//
//    /**
//     * 保存付款记录
//     *
//     * @param saveVO
//     * @return
//     */
//    @PostMapping("/saveW")
//    Long savePaymentRecordsW(@RequestBody PaymentRecordsSaveVO saveVO);

    /**
     * 根据来源单号批量逻辑删除
     *
     * @param optDocNos 来源单号
     * @return
     */
    @PostMapping("/deleteByOptDocNoBatch")
    void deleteByOptDocNoBatch(@RequestBody List<String> optDocNos);

    /**
     * 根据来源单据主键id批量逻辑删除
     *
     * @param optDocIds 来源单据主键id
     * @return
     */
    @PostMapping("/deleteByOptDocIdBatch")
    void deleteByOptDocIdBatch(@RequestBody List<Long> optDocIds);
}
