package com.elitesland.fin.param.recorder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Mark
 * @date 2024/08/26 09:16
 */
@Data
public class WeChatPayRecOrderRpcParam implements Serializable {

    private static final long serialVersionUID = 5946723129761085196L;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("微企付订单号")
    private String flowNo;

    @ApiModelProperty("收款方式")
    private String recType;

    @ApiModelProperty("微企付支付成功日期")
    private LocalDateTime payDateTime = LocalDateTime.now();

    @ApiModelProperty("币种编码")
    private String currCode = "CNY";

    @ApiModelProperty("币种名称")
    private String currName = "人民币";

    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;


}
