package com.elitesland.fin.dto.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

@Data
@ApiModel("门店主档数据")
public class StoreRpcDTO implements Serializable {

    @ApiModelProperty(value = "门店id")
    private Long storeId;

    @ApiModelProperty(value = "门店code")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "门店类型")
    private String storeType;

    @ApiModelProperty(value = "城市code")
    private String cityCode;

    @ApiModelProperty("建店日期")
    private LocalDate foundDate;

    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;

    @ApiModelProperty("加盟商名称")
    private String franchiseeName;

    @ApiModelProperty("地址簿编码")
    private Long addrNo;

    @ApiModelProperty("是否白名单")
    private String isWhite;

    @ApiModelProperty("物流厂商")
    @SysCode(sys = "yst-inv", mod = "WMS_TYPE")
    private String wmsType;

    @ApiModelProperty("物流厂商中文")
    private String wmsTypeName;

    @ApiModelProperty("仓库编号")
    private String whCode;
    @ApiModelProperty("特许权收取比例")
    private String royaltyRate;
    @ApiModelProperty("推广费收取比例")
    private String promotionRate;
}