package com.elitesland.fin.dto.paymentruleconfig;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2022/12/28 13:05
 */
@Data
public class PaymentRuleConfigDtlRpcDTO implements Serializable {

    @ApiModelProperty("账户类型")
    private String accountType;
    private String accountTypeName;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("可用金额")
    private BigDecimal availableAmount;

    @ApiModelProperty("订单可用金额")
    private BigDecimal orderAvailableAmount;

    @ApiModelProperty("优先级")
    private Integer priorityNo;

    @ApiModelProperty("支付规则id")
    private Long id;

    @ApiModelProperty("时间")
    private LocalDateTime time;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("订单可用支付金额")
    private BigDecimal orderTotalAvailableAmount;

    @ApiModelProperty("可开票金额")
    private BigDecimal invoiceAmount;

    @ApiModelProperty("支付金额")
    private BigDecimal paymentAmount;
}
