package com.elitesland.fin.enums;

import lombok.Getter;

/**
 * 支付规则
 *
 * @author yangzhibin
 * @date 2023/9/12
 */
@Getter
public enum PaymentRule {

    //订单
    PAY("支付", "SOPAY", "COMMAND", "30"),
    CANCEL("订单取消", "SO", "SO", "CL"),
    CLOSE("订单关闭", "SO", "SO", "DONE"),
    //发货单
    SHIPMENT("发货", "DO", "SO", "SHIP"),
    //退货单
    NO_ORIGINAL_RETURNED("无原单退货", "RSO", "RW", "DONE"),
    ORIGINAL_RETURNED("有原单退货", "RSO", "RJ", "DONE"),
    // 对账单-
    SACCK("对账单", "SACCK", "DA", "CONFIRM"),
    SACCK_RSO_CONFIRM("对账单-减", "SACCK", "RSO", "CONFIRM"),
    SACCK_SO_CONFIRM("对账单-增", "SACCK", "SO", "CONFIRM"),

    SACCK_RSO_RED_SUCCESS("对账单-减", "SACCK", "RSO", "RED_SUCCESS"),
    SACCK_SO_RED_SUCCESS("对账单-增", "SACCK", "SO", "RED_SUCCESS"),


    // 调拨单
    STKTRN_TRN_CF("调拨单出库确认出库释放流水", "STKTRN", "TRN", "CF"),
    STKTRN_TRN_APPED("调拨单审批通过", "STKTRN", "TRN", "APPED"),
    STKTRN_TRN_CL("调拨单撤销审批", "STKTRN", "TRN", "CL"),
    STKTRN_OUT_CF("调拨单出库确认出库扣减流水", "STKTRN", "OUT", "CF"),
    STKTRN_OUT_CE("调拨单出库出库作废", "STKTRN", "OUT", "CE"),
    STKTRN_IN_CF("调拨单入库确认入库", "STKTRN", "IN", "CF"),

    ;

    //描述
    private String desc;
    //财务需要信息
    private String doc;
    private String docType;
    private String docStatus;

    PaymentRule(String desc, String doc, String docType, String docStatus) {
        this.desc = desc;
        this.doc = doc;
        this.docType = docType;
        this.docStatus = docStatus;
    }

}
