package com.elitesland.fin.param.accountingengine;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明: 手动拟定参数
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/19
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "finJournalSyncRpcParam",description = "凭证同步金蝶参数")
public class FinJournalSyncRpcParam implements Serializable {
    private static final long serialVersionUID = 8112947044089351933L;

    @ApiModelProperty("ID")
    private Long id;
    private List<Long> idList;

    @ApiModelProperty("同步状态")
    private String syncStatus;

    @ApiModelProperty("失败原因")
    private String syncError;

    @ApiModelProperty("凭证号")
    private String billNo;

    @ApiModelProperty("主键ID")
    private String billId;

    @ApiModelProperty("凭证行号")
    private String billLineNo;

    @ApiModelProperty("行ID")
    private String billLineId;

    @ApiModelProperty("业务关键字")
    private String businessKey;
}
