package com.elitesland.fin.dto.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/12 16:14
 */
@Data
public class FinJournalRpcDTO implements Serializable {

    private static final long serialVersionUID = 3885513784926932000L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty("单据编码")
    private String docNum;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("来源系统编码")
    private String systemSourceCode;

    @ApiModelProperty("来源系统名称")
    private String systemSourceName;

    @ApiModelProperty("凭证编码")
    private String voucherTypeCode;

    @ApiModelProperty("凭证类型")
    private String voucherTypeName;

    @ApiModelProperty("核算维度1")
    private String segment1;

    @ApiModelProperty("核算维度2")
    private String segment2;

    @ApiModelProperty("核算维度3")
    private String segment3;

    @ApiModelProperty("核算维度4")
    private String segment4;

    @ApiModelProperty("核算维度5")
    private String segment5;

    @ApiModelProperty("核算维度6")
    private String segment6;

    @ApiModelProperty("核算维度7")
    private String segment7;

    @ApiModelProperty("核算维度8")
    private String segment8;

    @ApiModelProperty("核算维度9")
    private String segment9;

    @ApiModelProperty("核算维度10")
    private String segment10;

    @ApiModelProperty("核算维度11")
    private String segment11;

    @ApiModelProperty("核算维度12")
    private String segment12;

    @ApiModelProperty("核算维度13")
    private String segment13;

    @ApiModelProperty("核算维度14")
    private String segment14;

    @ApiModelProperty("核算维度15")
    private String segment15;

    @ApiModelProperty("核算维度16")
    private String segment16;

    @ApiModelProperty("核算维度17")
    private String segment17;

    @ApiModelProperty("核算维度18")
    private String segment18;

    @ApiModelProperty("借贷方 D/C")
    private String dc;

    @ApiModelProperty("借方金额")
    private BigDecimal debitAmt;

    @ApiModelProperty("贷方金额")
    private BigDecimal creditAmt;

    @ApiModelProperty("本币借方金额")
    private BigDecimal debitCurAmt;

    @ApiModelProperty("本币贷方金额")
    private BigDecimal creditCurAmt;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("总账日期")
    private LocalDateTime glDate;

    @ApiModelProperty("会计期间")
    private String accountPeriod;

    @ApiModelProperty("账套编码")
    private String sobLedgerCode;

    @ApiModelProperty("账套名称")
    private String sobLedgerName;

    @ApiModelProperty("业务单号")
    private String docNum1;

    @ApiModelProperty("会计引擎ID")
    private Long accountEngineId;

    @ApiModelProperty("会计引擎明细ID")
    private Long accountEngineDetailsId;

    @ApiModelProperty("记账行ID")
    private Long accEngDetDataId;

    @ApiModelProperty("摘要")
    private String finAbstract;

    @ApiModelProperty("现金流类型")
    private String cashFlow;

    @SysCode(sys = "yst-fin", mod = "PROPOSED_TYPE")
    @ApiModelProperty("传帐类型")
    private String transferType;
    private String transferTypeName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("传帐状态(yst-fin/AP_SYNC_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("推送日志")
    private String syncError;

    @ApiModelProperty("凭证号")
    private String billNo;

    @ApiModelProperty("主键ID")
    private String billId;

    @ApiModelProperty("凭证行号")
    private String billLineNo;

    @ApiModelProperty("行ID")
    private String billLineId;

    @ApiModelProperty("核算维度")
    private Map<String, Object> assgrp;


}
