package com.elitesland.fin.param.invoice;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "待开发票保存参数")
public class InvoiceAwaitSaveParam implements Serializable {

    private static final long serialVersionUID = 2617718744779453725L;

    @ApiModelProperty("待开发票单号")
    private String docNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("金额")
    private BigDecimal amt;

    @ApiModelProperty("待开发票状态")
    private String invoiceAwaitStatus;

    @ApiModelProperty("来源单据名称")
    private String optDocCls;

    @ApiModelProperty("来源单据类型")
    private String optDocType;

    @ApiModelProperty("可开票单据状态")
    private String optDocStatus;

    @ApiModelProperty("来源单号")
    private String optDocNo;

    @ApiModelProperty("发票文件编码")
    private String invoiceFileCode;

    @ApiModelProperty("开票申请单号")
    private String invoiceApplyNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("付款记录明细保存参数")
    private List<InvoiceAwaitDSaveParam> invoiceAwaitDSaveParamList;
}
