package com.elitesland.fin.param.creditaccountflow;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:信用账户流水
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Data
public class CreditAccountFlowRpcParam implements Serializable {

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源单据类型")
    private String sourceDocType;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    @ApiModelProperty("来源单据金额")
    private BigDecimal sourceDocAmount;

    @ApiModelProperty("来源单据门店编码")
    private String sourceDocStoreCode;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单据id")
    private Long sourceId;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;
}
