package com.elitesland.fin.param.arorder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/02/27
 * @Version 1.0
 * @Content:
 */
@Data
public class ArOrderRecordRpcParam implements Serializable {
    private static final long serialVersionUID = 4998201233358350725L;

     /*@ApiModelProperty("来源单据")
    private String sourceDoc;*/

    @ApiModelProperty("来源单据类型")
    private String sourceDocType;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("部门ID")
    private Long buId;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("部门名称")
    private String buName;

    @ApiModelProperty("付款条件")
    private String payMentName;

    @ApiModelProperty("付款条件id")
    private String payMentId;

    @ApiModelProperty("付款条件code")
    private String payMentCode;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员code")
    private String saleUserCode;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("订单客户")
    private String es1;

    @ApiModelProperty("发票号")
    private String es2;

    @ApiModelProperty("开票日期")
    private LocalDateTime es3;

    @ApiModelProperty("发票类型")
    private String es4;

    @ApiModelProperty("起算日期")
    private LocalDateTime es5;

    @ApiModelProperty("红冲标志")
    private String es6;

    @ApiModelProperty("收款协议编码")
    private String protocolCode;

    @ApiModelProperty("明细数据")
    private List<ArOrderDtlRecordRpcParam> arOrderDtlRecordRpcParams;

}
