package com.elitesland.fin.service.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.accountingengine.FinJournalRpcDTO;
import com.elitesland.fin.param.accountingengine.FinJournalRpcParam;
import com.elitesland.fin.param.accountingengine.FinJournalSyncRpcParam;
import com.elitesland.fin.param.accountingengine.ManualProposedRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/19
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + JournalGenerateRpcService.PATH)
public interface JournalGenerateRpcService {

    String PATH = "/manualProposed";

    /**
     * 手动生成凭证
     *
     * @param rpcParam 入参
     * @return
     */
    @PostMapping("/manualProposed")
    ApiResult<Void> manualProposed(@RequestBody ManualProposedRpcParam rpcParam);

    /**
     * 查询待同步的凭证
     *
     * @param param 入参
     * @return
     */
    @PostMapping("/findWaitSyncJournal")
    ApiResult<List<FinJournalRpcDTO>> findWaitSyncJournal(@RequestBody FinJournalRpcParam param);

    /**
     * 更新状态并回写业务单据状态
     * @param param
     * @return
     */
    @GetMapping("/updateSyncStatus")
    ApiResult<Void> updateSyncStatus(@RequestBody List<FinJournalSyncRpcParam> param);

    /**
     * 批量更新状态(idList)
     * @param param
     * @return
     */
    @GetMapping("/updateSyncStatusBatch")
    ApiResult<Void> updateSyncStatusBatch(@RequestBody FinJournalSyncRpcParam param);

    /**
     * 凭证删除/红冲(只需要参数billId)
     * @param param
     * @return
     */
    @GetMapping("/deleteByBillId")
    ApiResult<Void> deleteByBillId(@RequestBody FinJournalSyncRpcParam param);
}
