package com.elitesland.fin.service.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.accountingengine.FinFlexibleRpcDTO;
import com.elitesland.fin.param.accountingengine.FinFlexibleValueSaveRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;


/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/19
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + FinFlexibleRpcService.PATH)
public interface FinFlexibleRpcService {

    String PATH = "/finFlexible";

    /**
     * 根据编码查询值集信息，包含明细
     * @return
     */
    @GetMapping("/findFlexibleByCode")
    ApiResult<FinFlexibleRpcDTO> findFlexibleByCode(@RequestParam(name = "flexibleCode") @NotBlank(message = "值集编码") String flexibleCode);

    /**
     * 根据编码查询账簿信息，包含明细
     * @return
     */
    @PostMapping("/batchSave")
    ApiResult<Void> batchSave(@RequestBody List<FinFlexibleValueSaveRpcParam> paramList);

}
