package com.elitesland.fin.param.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 天龙对账单参数类
 *
 * @author elitesland
 */
@Data
@ApiModel("天龙对账单参数")
public class TcStatementAccountParam {

    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "对账流水号")
    private String reconciliationNo;

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "门店经营性质")
    private String storeBusinessType;

    @ApiModelProperty(value = "对账日期")
    private LocalDate reconciliationDate;

    @ApiModelProperty(value = "拟定状态")
    private String proposedStatus;

    @ApiModelProperty(value = "传账状态")
    private String transferStatus;

    @ApiModelProperty(value = "对账类型")
    private String reconciliationType;

    @ApiModelProperty(value = "对账模式")
    private String reconciliationMode;

    @ApiModelProperty(value = "A方总金额")
    private BigDecimal partyATotalAmount;

    @ApiModelProperty(value = "A方总笔数")
    private Integer partyATotalCount;

    @ApiModelProperty(value = "B方总金额")
    private BigDecimal partyBTotalAmount;

    @ApiModelProperty(value = "B方总笔数")
    private Integer partyBTotalCount;

    @ApiModelProperty(value = "平账笔数")
    private Integer balancedCount;

    @ApiModelProperty(value = "平账金额")
    private BigDecimal balancedAmount;

    @ApiModelProperty(value = "A方单边笔数")
    private Integer partyASingleSideCount;

    @ApiModelProperty(value = "A方单边金额")
    private BigDecimal partyASingleSideAmount;

    @ApiModelProperty(value = "B方单边笔数")
    private Integer partyBSingleSideCount;

    @ApiModelProperty(value = "B方单边金额")
    private BigDecimal partyBSingleSideAmount;

    @ApiModelProperty(value = "金额差异笔数")
    private Integer amountDiffCount;

    @ApiModelProperty(value = "A方差异单金额")
    private BigDecimal partyADiffAmount;

    @ApiModelProperty(value = "B方差异单金额")
    private BigDecimal partyBDiffAmount;

    @ApiModelProperty(value = "差异金额")
    private BigDecimal totalDiffAmount;

    @ApiModelProperty(value = "重复笔数")
    private Integer duplicateCount;

    @ApiModelProperty(value = "重复金额")
    private BigDecimal duplicateAmount;

    @ApiModelProperty(value = "滚动对平笔数")
    private Integer rollingBalancedCount;

    @ApiModelProperty(value = "滚动对平金额")
    private BigDecimal rollingBalancedAmount;

    @ApiModelProperty(value = "核销笔数")
    private Integer writeOffCount;

    @ApiModelProperty(value = "核销金额")
    private BigDecimal writeOffAmount;

    @ApiModelProperty(value = "天财执行时间")
    private LocalDateTime tiancaiExecTime;

    @ApiModelProperty(value = "同步时间")
    private LocalDateTime syncTime;

    @ApiModelProperty(value = "核销标识")
    private String wirteOffMark;

    @ApiModelProperty( value = "平账标识")
    private String accountBalancingMark;


}