package com.elitesland.fin.dto.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/12 16:14
 */
@Data
public class FinFlexibleRpcDTO implements Serializable {

    private static final long serialVersionUID = 3885513784926932000L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("值集编码")
    private String flexibleCode;

    @ApiModelProperty("值集名称")
    private String flexibleName;

    @ApiModelProperty("值集类型，0：主值集，1：从属值集")
    @SysCode(sys = "yst-fin", mod = "FLEXIBLE_TYPE")
    private String flexibleType;
    private String flexibleTypeName;

    @ApiModelProperty("主值集编码")
    private String parentFlexibleCode;

    @ApiModelProperty("主值集名称")
    private String parentFlexibleName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("值集明细")
    private List<FinFlexibleValueRpcDTO> detailList;
}
