package com.elitesland.fin.dto.accountingengine;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/12 16:14
 */
@Data
public class FinSetOfBookLineRpcDTO implements Serializable {

    private static final long serialVersionUID = 3885513784926932000L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("字段名称")
    private String columnName;

    @ApiModelProperty("核算维度编码")
    private String accountDimenCode;

    @ApiModelProperty("核算维度名称")
    private String accountDimenName;

    @ApiModelProperty("是否是值集")
    private Boolean flexibleFlag;

    @ApiModelProperty("值集编码")
    private String flexibleCode;

    @ApiModelProperty("值集名称")
    private String flexibleName;
}
