package com.elitesland.fin.param.saleinv;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2023/05/25
 */
@Data
@ApiModel("发票数据")
public class InvoiceSaveParam implements Serializable {

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("发票号码")
    private String invNo;

    @ApiModelProperty("发票代码")
    private String invCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("校验码")
    private String checkCode;

    @ApiModelProperty("原蓝票代码")
    private String blueInvCode;

    @ApiModelProperty("原蓝票号码")
    private String blueInvNo;

    @ApiModelProperty("开票金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty("红冲状态")
    private String redState;

    @ApiModelProperty("开票状态")
    private String invState;

    @ApiModelProperty("pdf链接")
    private String invPdfUrl;

    @ApiModelProperty("开票失败原因")
    private String invFailCause;
}
