package com.elitesland.fin.param.aporder;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/11/04
 * @Version 1.0
 * @Content:
 */
@Data
public class ApOrderHandleRpcParam implements Serializable {
    private static final long serialVersionUID = -4183410324539621637L;


    @ApiModelProperty(value = "内外部客户(供应商的内外部)")
    private String inOutCust;


    private Long id;

    private String sourceNo;

    private String apOrderNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private String createMode;

    private Long apTypeId;

    private String apTypeName;

    private String apTypeCode;

    private String orderState;

    private LocalDateTime buDate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String currCode;

    private String currName;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private BigDecimal exchangeRate;

    private Long operUserId;

    private String operator;

    private Boolean taxFlag;

    private Boolean initFlag;

    private String auditRejection;

    private Long suppId;

    private String suppCode;

    private String suppName;

    private Long buId;

    private String buCode;

    private String buName;

    private String buType;

    private String payMentName;

    private String payMentId;

    private String payMentCode;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal taxRate;

    private String remark;

    private List<ApOrderDtlHandleRpcParam> apOrderDtlList;

    private List<ApOrderDtlGroupHandleRpcParam> apOrderDtlGroupList;

    private String verState;

    private BigDecimal verAmt;

    private String creator;

    private Integer auditDataVersion;

    private String procInstId;

    //private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private String addrNo;

    private String suppAddrNo;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    private String proposedStatus;

    private Boolean check = Boolean.TRUE;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("付款协议名称")
    private String protocolName;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;
}
