package com.elitesland.fin.param.accountingengine;

import com.elitesland.fin.dto.accountingengine.FinFlexibleValueCheckItemRpcDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/12 16:14
 */
@Data
public class FinFlexibleValueSaveRpcParam implements Serializable {

    private static final long serialVersionUID = 3885513784926932000L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("主表ids")
    private List<Long> masIds;

    @ApiModelProperty("序号")
    private Integer serialNum;

    @ApiModelProperty("值")
    private String flexibleValueCode;

    @ApiModelProperty("值名称")
    private String flexibleValueName;

    @ApiModelProperty("是否有子代")
    private Boolean descendantsFlag;

    @ApiModelProperty("是否启用")
    private Boolean activeFlag;

    @ApiModelProperty("是否记账")
    private Boolean accountFlag;

    @ApiModelProperty("主值")
    private String masFlexibleValueCode;

    @ApiModelProperty("主值名称")
    private String masFlexibleValueName;

    @ApiModelProperty("起始有效日期")
    private LocalDateTime activeStartTime;

    @ApiModelProperty("终止有效日期")
    private LocalDateTime activeEndTime;

    @ApiModelProperty("上级值")
    private String parentFlexibleValueCode;

    @ApiModelProperty("上级值名称")
    private String parentFlexibleValueName;
    @ApiModelProperty("值集编码")
    private String flexibleCode;

    @ApiModelProperty("账套编码")
    private String sobCode;

    @ApiModelProperty("字段名称")
    private String columnName;

    @ApiModelProperty("账套编码")
    private List<String> sobCodes;

    @ApiModelProperty("核算维度")
    private String checkitementry;

    @ApiModelProperty("核算维度数组")
    private List<FinFlexibleValueCheckItemRpcDTO> checkItemList;

    @ApiModelProperty("现金科目")
    private Boolean iscash;

    @ApiModelProperty("银行科目")
    private Boolean isbank;

    @ApiModelProperty("层级")
    private Integer level;


}
