package com.elitesland.fin.service.aporder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.aporder.ApArOrderHandleRpcDTO;
import com.elitesland.fin.dto.aporder.ApOrderRpcDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.param.aporder.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * 应付单
 * @Package com.elitesland.fin.service
 * @date 2022/5/17 15:25
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + ApOrderRpcService.PATH)
public interface ApOrderRpcService {

    String PATH = "/apOrder";

    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody ApOrderRpcParam apOrderRpcParam);

    /**
     * 应付单查询
     */
    @PostMapping("/queryApOrderById")
    ApiResult<ApOrderRpcDTO> queryApOrderById(@RequestBody Long id);

    /**
     * 应付单列表查询
     */
    @PostMapping("/page")
    ApiResult<PagingVO<ApOrderRpcDTO>> page(@RequestBody ApOrderPageRpcParam apOrderPageRpcParam);

    /**
     * 公司间事务账单生成应收应付
     */
    @PostMapping("/invInterTranGenApAr")
    ApiResult<ApArOrderHandleRpcDTO> invInterTranGenApAr(@RequestBody ApArOrderHandleRpcParam apArOrderRpcParam);

    /**
     * 应付单列表查询
     */
    @PostMapping("/findSyncApOrder")
    ApiResult<List<ApOrderRpcDTO>> findSyncApOrder(@RequestBody ApOrderSyncRpcParam param);

    /**
     * 更新同步状态更新状态
     * @param param
     * @return
     */
    @GetMapping("/updateSyncStatus")
    ApiResult<Void> updateSyncStatus(@RequestBody List<ApOrderSyncResultRpcParam> param);
}
