package com.elitesland.fin.param.account;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 天龙对账单分页查询参数
 *
 * @author elitesland
 */
@Data
@ApiModel(description = "天龙对账单分页查询参数")
public class TcStatementAccountPageParam extends AbstractCustomFieldQueryParam {

    private List<Long> ids;

    @ApiModelProperty("对账流水号")
    private String reconciliationNo;

    @ApiModelProperty("门店编号")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("门店经营性质")
    private String storeBusinessType;

    @ApiModelProperty("对账日期开始")
    private LocalDate reconciliationDateStart;

    @ApiModelProperty("对账日期结束")
    private LocalDate reconciliationDateEnd;

    @ApiModelProperty("拟定状态")
    private String draftStatus;

    @ApiModelProperty("传账状态")
    private String transferStatus;

    @ApiModelProperty("对账类型")
    private String reconciliationType;

    @ApiModelProperty("对账模式")
    private String reconciliationMode;

    @ApiModelProperty("A方总金额最小值")
    private BigDecimal partyATotalAmountMin;

    @ApiModelProperty("A方总金额最大值")
    private BigDecimal partyATotalAmountMax;

    @ApiModelProperty("B方总金额最小值")
    private BigDecimal partyBTotalAmountMin;

    @ApiModelProperty("B方总金额最大值")
    private BigDecimal partyBTotalAmountMax;

    @ApiModelProperty("创建时间开始")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("创建时间结束")
    private LocalDateTime createTimeEnd;

//    @ApiModelProperty(value = "核销标识")
//    private String wirteOffMark;
//
//    @ApiModelProperty( value = "平账标识")
//    private String accountBalancingMark;
}