package com.elitesland.fin.dto.pay;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2023/1/6 14:44
 */
@Data
public class DrawBackRpcDTO implements Serializable {
    private static final long serialVersionUID = -3217888822100353717L;

    @ApiModelProperty("退款方式")
    private String payMethod;

    @ApiModelProperty("收款类型")
    private String receiptType;

    @ApiModelProperty("退款金额")
    private BigDecimal payAmount;

    @ApiModelProperty("订单编号")
    private String orderNumber;

    @ApiModelProperty("收款公司id")
    private Long receiptOuId;

    @ApiModelProperty("收款公司编号")
    private String receiptOuCode;

    @ApiModelProperty("收款公司名称")
    private String receiptOuName;

    @ApiModelProperty("收款公司账户")
    private String receiptAccount;

    @ApiModelProperty("付款公司id")
    private Long payOuId;

    @ApiModelProperty("付款公司编号")
    private String payOuCode;

    @ApiModelProperty("付款公司名称")
    private String payOuName;

    @ApiModelProperty("付款公司账户")
    private String payAccount;
}
