package com.elitesland.fin.service.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.account.AccountAmtFlowRpcVO;
import com.elitesland.fin.dto.account.AccountRpcDTO;
import com.elitesland.fin.param.account.AccountAppRpcParam;
import com.elitesland.fin.param.account.AccountRpcParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.service.account
 * @date 2023/3/7 13:56
 */

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + AccountRpcService.PATH)
public interface AccountRpcService {

    String PATH = "/account";


    @PostMapping("/createAccount")
    ApiResult<Void> createAccount(@RequestBody List<AccountRpcParam> accountRpcParamList);

    @PostMapping("/queryAccount")
    ApiResult<List<AccountRpcDTO>> queryAccount(@RequestBody AccountRpcParam accountRpcParam);

    @ApiOperation("根据客户编码、公司和账户类型查询账户和信用账户的金额和流水信息")
    @PostMapping("/select/accountAmtAndFlow")
    ApiResult<AccountAmtFlowRpcVO> selectAccountAmtAndFlow(@RequestBody AccountAppRpcParam accountAppParam);

}
