package com.elitesland.fin.dto.account;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class StoreReceivePageRpcVO implements Serializable {

    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("收/退货id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long docId;

    @ApiModelProperty("收/退货单号")
    private String docNo;

    @ApiModelProperty("订货单id")
    private Long orderId;

    @ApiModelProperty("订货单单号")
    private String orderNo;

    @ApiModelProperty("订货集id")
    private Long orderSetId;

    @ApiModelProperty("总数量")
    private BigDecimal totalQty;

    @ApiModelProperty("总实际数量")
    private BigDecimal totalRealQty;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("总实际金额")
    private BigDecimal realAmt;

    @ApiModelProperty("单据创建日期")
    private LocalDateTime docCreateDate;

    @ApiModelProperty("订货日期")
    private LocalDateTime orderDate;

    @ApiModelProperty("发货日期")
    private LocalDateTime deliveryDate;

    @ApiModelProperty("收货日期")
    private LocalDateTime receiveDate;

    @ApiModelProperty("单据类型，TRN：仓配-调拨单，GR：供应商直发，采购收货单")
    private String docType;

    private String docTypeName;

    @ApiModelProperty("状态，DR：退货待审，CE：待收货/待退货、CF：已收货/已退货、CL：已取消")
    private String status;

    @ApiModelProperty("状态，DR：退货待审，CE：待收货/待退货、CF：已收货/已退货、CL：已取消")
    private String statusName;

    private String rtType;

    @ApiModelProperty("退货申请是否可作废，true：可以，false：不可以")
    private boolean canAbort;

    @ApiModelProperty("账户或信用账户和流水")
    private List<AccountFlowAppRpcVO> flowList;
}