package com.elitesland.fin.dto.account;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/09
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "accountTypeFlowVO",description = "按照类型查询账户、信用账户和流水信息出参")
public class AccountAmtFlowRpcVO implements Serializable {
    private static final long serialVersionUID = 6951953004687690898L;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_TYPE")
    private String accountType;
    @ApiModelProperty("账户类型名称")
    private String accountTypeName;

    @ApiModelProperty("余额")
    private BigDecimal accountAmount;

    @ApiModelProperty("占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("订货订单")
    private PagingVO<StoreReceivePageRpcVO>  storeReceivePageVO;

//    @ApiModelProperty("账户或信用账户和流水")
//    private PagingVO<AccountFlowAppRpcVO> flowPagingVO;


}
