/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.invoice;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.PaymentRecordsParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.entity.invoice.QPaymentRecordsDDO;
import com.elitesland.fin.entity.invoice.QPaymentRecordsDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class PaymentRecordsRepoProc {
    private static final QPaymentRecordsDO paymentRecordsDO = QPaymentRecordsDO.paymentRecordsDO;
    private static final QPaymentRecordsDDO paymentRecordsDDO = QPaymentRecordsDDO.paymentRecordsDDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<InvoiceAwaitRespVO> paymentList;
    private final QBean<InvoiceAwaitRespVO> detailList;

    public long countPaymentRecords(PaymentRecordsParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)paymentRecordsDO.count()).from((EntityPath)paymentRecordsDO);
        jpaQuery.where(this.wherePaymentRecords(paramVO));
        return jpaQuery.fetchCount();
    }

    public PagingVO<InvoiceAwaitRespVO> queryPaymentRecords(PaymentRecordsParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.paymentList).from((EntityPath)paymentRecordsDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, paymentRecordsDO);
        jpaQuery.where(this.wherePaymentRecords(paramVO));
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    public List<InvoiceAwaitRespVO> queryPaymentDetails(PaymentRecordsParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.detailList).from((EntityPath)paymentRecordsDO)).leftJoin((EntityPath)paymentRecordsDDO)).on((Predicate)PaymentRecordsRepoProc.paymentRecordsDO.id.eq(PaymentRecordsRepoProc.paymentRecordsDDO.masId));
        jpaQuery.where(this.wherePaymentRecords(paramVO));
        return jpaQuery.fetch();
    }

    public List<InvoiceAwaitRespVO> findByIds(List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.id.in(ids));
        predicates.add(PaymentRecordsRepoProc.paymentRecordsDDO.isToBilling.eq((Object)"0"));
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.detailList).from((EntityPath)paymentRecordsDO)).leftJoin((EntityPath)paymentRecordsDDO)).on((Predicate)PaymentRecordsRepoProc.paymentRecordsDO.id.eq(PaymentRecordsRepoProc.paymentRecordsDDO.masId))).where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    private Predicate wherePaymentRecords(PaymentRecordsParam paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getChargeType())) {
            BooleanExpression matchExpress = PaymentRecordsRepoProc.paymentRecordsDDO.itemCode.eq((Object)paramVO.getChargeType());
            predicates.add(((JPQLQuery)JPAExpressions.selectFrom((EntityPath)paymentRecordsDDO).where(new Predicate[]{PaymentRecordsRepoProc.paymentRecordsDDO.masId.eq(PaymentRecordsRepoProc.paymentRecordsDO.id).and((Predicate)matchExpress)})).exists());
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getPaymentDateStart())) {
            predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.paymentDate.after((Comparable)paramVO.getPaymentDateStart()).or((Predicate)PaymentRecordsRepoProc.paymentRecordsDO.paymentDate.eq((Object)paramVO.getPaymentDateStart())));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getPaymentDateEnd())) {
            predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.paymentDate.before((Comparable)paramVO.getPaymentDateEnd()).or((Predicate)PaymentRecordsRepoProc.paymentRecordsDO.paymentDate.eq((Object)paramVO.getPaymentDateEnd())));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getPaymentStatus())) {
            predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.paymentStatus.eq((Object)paramVO.getPaymentStatus()));
        }
        if (ObjectUtil.isNotNull((Object)paramVO.getMasId())) {
            predicates.add(PaymentRecordsRepoProc.paymentRecordsDDO.masId.eq((Object)paramVO.getMasId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getSourceNo())) {
            predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.sourceDocNo.eq((Object)paramVO.getSourceNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getOuCode())) {
            predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.ouCode.eq((Object)paramVO.getOuCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getOuName())) {
            predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.ouName.like("%" + paramVO.getOuName() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getCustCodeName())) {
            String likeStr = "%" + paramVO.getCustCodeName() + "%";
            predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.custCode.like(likeStr).or((Predicate)PaymentRecordsRepoProc.paymentRecordsDO.custName.like(likeStr)));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long updatePaymentStatus(long id, String status, long receiptId, BigDecimal realRecAmt, String recOrderNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.id.eq((Object)id));
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)paymentRecordsDO).set((Path)PaymentRecordsRepoProc.paymentRecordsDO.paymentStatus, (Object)status).set(PaymentRecordsRepoProc.paymentRecordsDO.receiptId, (Object)receiptId).set(PaymentRecordsRepoProc.paymentRecordsDO.realRecAmt, (Object)realRecAmt).set((Path)PaymentRecordsRepoProc.paymentRecordsDO.associateNumber, (Object)recOrderNo).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return update.execute();
    }

    public long updatePayment(long id, String recOrderNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(PaymentRecordsRepoProc.paymentRecordsDO.id.eq((Object)id));
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)paymentRecordsDO).set((Path)PaymentRecordsRepoProc.paymentRecordsDO.associateNumber, (Object)recOrderNo).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return update.execute();
    }

    public long updatePaymentDStatus(long id, String status, long receiptId, BigDecimal realRecAmt) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(PaymentRecordsRepoProc.paymentRecordsDDO.id.eq((Object)id));
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)paymentRecordsDDO).set((Path)PaymentRecordsRepoProc.paymentRecordsDDO.paymentStatus, (Object)status).set(PaymentRecordsRepoProc.paymentRecordsDDO.receiptId, (Object)receiptId).set(PaymentRecordsRepoProc.paymentRecordsDDO.realRecAmt, (Object)realRecAmt).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return update.execute();
    }

    public List<InvoiceAwaitRespVO> findByDetails(List<Long> bizKey) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.detailList).from((EntityPath)paymentRecordsDO)).leftJoin((EntityPath)paymentRecordsDDO)).on((Predicate)PaymentRecordsRepoProc.paymentRecordsDO.id.eq(PaymentRecordsRepoProc.paymentRecordsDDO.masId))).where((Predicate)PaymentRecordsRepoProc.paymentRecordsDDO.id.in(bizKey));
        return jpaQuery.fetch();
    }

    public long updateInvoiceInfo(List<String> paymentNoList, String invoiceInfo) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)paymentRecordsDO).set((Path)PaymentRecordsRepoProc.paymentRecordsDO.invoiceInfo, (Object)invoiceInfo).where(new Predicate[]{PaymentRecordsRepoProc.paymentRecordsDO.docNo.in(paymentNoList)});
        return update.execute();
    }

    public List<String> getSourceIdByDocNo(List<String> paymentNoList, String sourceDocType) {
        JPAQuery where = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)PaymentRecordsRepoProc.paymentRecordsDO.sourceDocNo).from((EntityPath)paymentRecordsDO)).where((Predicate)PaymentRecordsRepoProc.paymentRecordsDO.docNo.in(paymentNoList).and((Predicate)PaymentRecordsRepoProc.paymentRecordsDO.sourceDocType.eq((Object)sourceDocType)));
        return where.fetch();
    }

    public PaymentRecordsRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.paymentList = Projections.bean(InvoiceAwaitRespVO.class, (Expression[])new Expression[]{PaymentRecordsRepoProc.paymentRecordsDO.id, PaymentRecordsRepoProc.paymentRecordsDO.docNo, PaymentRecordsRepoProc.paymentRecordsDO.noticeId, PaymentRecordsRepoProc.paymentRecordsDO.franchiseeId, PaymentRecordsRepoProc.paymentRecordsDO.paymentStatus, PaymentRecordsRepoProc.paymentRecordsDO.invBankNo, PaymentRecordsRepoProc.paymentRecordsDO.ouCode, PaymentRecordsRepoProc.paymentRecordsDO.ouName, PaymentRecordsRepoProc.paymentRecordsDO.ouId, PaymentRecordsRepoProc.paymentRecordsDO.custCode, PaymentRecordsRepoProc.paymentRecordsDO.custName, PaymentRecordsRepoProc.paymentRecordsDO.custId, PaymentRecordsRepoProc.paymentRecordsDO.bankAccount, PaymentRecordsRepoProc.paymentRecordsDO.amt, PaymentRecordsRepoProc.paymentRecordsDO.noticeDate, PaymentRecordsRepoProc.paymentRecordsDO.associateNumber, PaymentRecordsRepoProc.paymentRecordsDO.paymentDate, PaymentRecordsRepoProc.paymentRecordsDO.noticeContent, PaymentRecordsRepoProc.paymentRecordsDO.voucherFileCode, PaymentRecordsRepoProc.paymentRecordsDO.uniBankNo, PaymentRecordsRepoProc.paymentRecordsDO.storeCode, PaymentRecordsRepoProc.paymentRecordsDO.sourceDocType, PaymentRecordsRepoProc.paymentRecordsDO.realRecAmt, PaymentRecordsRepoProc.paymentRecordsDO.sourceDocId, PaymentRecordsRepoProc.paymentRecordsDO.sourceDocNo, PaymentRecordsRepoProc.paymentRecordsDO.receiptId, PaymentRecordsRepoProc.paymentRecordsDO.invoiceInfo, PaymentRecordsRepoProc.paymentRecordsDO.payAccount, PaymentRecordsRepoProc.paymentRecordsDO.payType, PaymentRecordsRepoProc.paymentRecordsDO.payBank});
        this.detailList = Projections.bean(InvoiceAwaitRespVO.class, (Expression[])new Expression[]{PaymentRecordsRepoProc.paymentRecordsDDO.id, PaymentRecordsRepoProc.paymentRecordsDO.id.as("masId"), PaymentRecordsRepoProc.paymentRecordsDO.docNo, PaymentRecordsRepoProc.paymentRecordsDO.noticeId, PaymentRecordsRepoProc.paymentRecordsDO.franchiseeId, PaymentRecordsRepoProc.paymentRecordsDO.invBankNo, PaymentRecordsRepoProc.paymentRecordsDO.ouCode, PaymentRecordsRepoProc.paymentRecordsDO.ouName, PaymentRecordsRepoProc.paymentRecordsDO.ouId, PaymentRecordsRepoProc.paymentRecordsDO.bankAccount, PaymentRecordsRepoProc.paymentRecordsDO.noticeDate, PaymentRecordsRepoProc.paymentRecordsDO.paymentDate, PaymentRecordsRepoProc.paymentRecordsDO.noticeContent, PaymentRecordsRepoProc.paymentRecordsDO.voucherFileCode, PaymentRecordsRepoProc.paymentRecordsDO.uniBankNo, PaymentRecordsRepoProc.paymentRecordsDO.storeCode, PaymentRecordsRepoProc.paymentRecordsDO.sourceDocType, PaymentRecordsRepoProc.paymentRecordsDO.sourceDocId, PaymentRecordsRepoProc.paymentRecordsDO.paymentStatus, PaymentRecordsRepoProc.paymentRecordsDDO.lineNo, PaymentRecordsRepoProc.paymentRecordsDDO.itemCode, PaymentRecordsRepoProc.paymentRecordsDDO.taxRate, PaymentRecordsRepoProc.paymentRecordsDDO.amt, PaymentRecordsRepoProc.paymentRecordsDDO.remark, PaymentRecordsRepoProc.paymentRecordsDDO.realRecAmt, PaymentRecordsRepoProc.paymentRecordsDDO.receiptId, PaymentRecordsRepoProc.paymentRecordsDDO.isToBilling, PaymentRecordsRepoProc.paymentRecordsDO.payBank, PaymentRecordsRepoProc.paymentRecordsDO.payAccount, PaymentRecordsRepoProc.paymentRecordsDO.payType});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

