/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.saleinv;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.dto.mq.DemoMqMessageDTO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.service.workflow.saleinv.SaleInvProcessService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleInvProcessServiceImpl
implements SaleInvProcessService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final SaleInvRepoProc saleInvRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final MessageQueueTemplate messageQueueTemplate;
    private final InvoiceAwaitRepoProc invoiceAwaitRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        SaleInvDTO saleInvDTO = this.saleInvRepoProc.get(id);
        if (saleInvDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QSaleInvDO saleInvDO = QSaleInvDO.saleInvDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)saleInvDO).set(saleInvDO.procInstStatus, (Object)procInstStatus).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName()).where(new Predicate[]{saleInvDO.id.eq((Object)id)});
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        String clientIp = HttpServletUtil.currentClientIp();
        log.info("SaleInvProcessServiceImpl \u83b7\u53d6\u767b\u5f55\u4eba\u4fe1\u606f:{} ", (Object)JSON.toJSONString((Object)currentUser));
        if (currentUser != null) {
            saleInvDTO.setOperationIp(currentUser.getIp());
            saleInvDTO.setOperationName(currentUser.getUser().getLastName());
            saleInvDTO.setOperationUserId(currentUser.getUserId());
            saleInvDTO.setOperationUserName(currentUser.getUsername());
        } else {
            saleInvDTO.setOperationUserId(Long.valueOf(commentInfo.getUserId()));
            saleInvDTO.setOperationUserName(commentInfo.getUserName());
        }
        saleInvDTO.setOperationIp(clientIp);
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                jpaUpdateClause.set(saleInvDO.procInstStatus, (Object)ProcInstStatus.REJECTED);
                this.updateInvoiceAwaitStatus(saleInvDTO.getApplyNo(), UdcEnum.INV_STATE_WAIT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_EXPIRED.getValueCode()).set((Path)saleInvDO.procInstId, (Object)null);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                this.updateInvoiceAwaitStatus(saleInvDTO.getApplyNo(), UdcEnum.INV_STATE_WAIT.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).set((Path)saleInvDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
                this.updateInvoiceAwaitStatus(saleInvDTO.getApplyNo(), UdcEnum.INV_STATE_ING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set(saleInvDO.approvedTime, (Object)LocalDateTime.now());
                this.sendMessage(saleInvDTO);
                break;
            }
        }
        jpaUpdateClause.execute();
    }

    private void updateInvoiceAwaitStatus(String applyNo, String invState) {
        SaleInvStatusParam saleInvStatusParam = new SaleInvStatusParam();
        saleInvStatusParam.setApplyNo(applyNo);
        saleInvStatusParam.setInvState(invState);
        this.invoiceAwaitRepoProc.updateInvState(saleInvStatusParam);
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        SaleInvDTO saleInvDTO = this.saleInvRepoProc.get(businessId);
        if (saleInvDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(saleInvDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    private void sendMessage(SaleInvDTO saleInvDTO) {
        DemoMqMessageDTO messageDTO = new DemoMqMessageDTO();
        messageDTO.setId(saleInvDTO.getId());
        messageDTO.setCode(saleInvDTO.getApplyNo());
        messageDTO.setInterfaceType("zt_to_nc_salinv");
        messageDTO.setDomainCode("yst-fin");
        messageDTO.setOperationIp(saleInvDTO.getOperationIp());
        messageDTO.setOperationName(saleInvDTO.getOperationName());
        messageDTO.setOperationUserId(saleInvDTO.getOperationUserId());
        messageDTO.setOperationUserName(saleInvDTO.getOperationUserName());
        try {
            this.messageQueueTemplate.publishMessage("yst-fin", "yst-fin", (Serializable)messageDTO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
            throw new BusinessException("\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25");
        }
    }

    public SaleInvProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, SaleInvRepoProc saleInvRepoProc, JPAQueryFactory jpaQueryFactory, MessageQueueTemplate messageQueueTemplate, InvoiceAwaitRepoProc invoiceAwaitRepoProc) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.saleInvRepoProc = saleInvRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.messageQueueTemplate = messageQueueTemplate;
        this.invoiceAwaitRepoProc = invoiceAwaitRepoProc;
    }
}

