/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.aporder;

import com.alibaba.excel.EasyExcelFactory;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApOrderServiceImpl
implements ApOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApOrderServiceImpl.class);
    private final ApOrderDomainService apOrderDomainService;
    private final ApOrderDtlDomainService apOrderDtlDomainService;
    private final WorkflowRpcService workflowRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ApOrderVO> page(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = this.apOrderDomainService.page(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        return res;
    }

    @Override
    @SysCodeProc
    public ApOrderVO get(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.get(id);
        ApOrderVO res = ApOrderConvert.INSTANCE.convert(apOrderDTO);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> audit(Long id) {
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> refush(List<Long> ids, String content) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long res = this.apOrderDomainService.audit(ids, content, user);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> del(List<Long> ids) {
        Long res = this.apOrderDomainService.del(ids);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ApOrderSaveParam apOrderSaveParam) {
        if (!apOrderSaveParam.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("\u65b0\u589e\u7684\u5355\u636e\u6765\u6e90\u9700\u4e3a\u624b\u5de5");
        }
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long res = this.apOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public ApiResult<Long> commit(ApOrderSaveParam apOrderSaveParam) {
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long resId = this.apOrderDomainService.commit(apOrder);
        if (apOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(apOrder.getProcInstStatus())) {
            String procInstName = "\u5e94\u4ed8\u5355\u5ba1\u6838-" + apOrder.getApOrderNo();
            String procKey = WorkFlowDefKey.FIN_AP_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.apOrderDomainService.updateWorkInfo(processInfo, resId);
        }
        return ApiResult.ok((Object)resId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(ApOrderSaveParam apOrderSaveParam) {
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        apOrder.checkUpdate();
        Long res = this.apOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ApOrderVO getApOrderAndDtl(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.getApOrderAndDtl(id);
        ApOrderVO res = ApOrderConvert.INSTANCE.convert(apOrderDTO);
        return res;
    }

    @Override
    @SysCodeProc
    public void exportExl(HttpServletResponse response, ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = this.apOrderDomainService.page(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u91c7\u8d2d\u7ed3\u7b97\u5355", "UTF-8").replace("+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelFactory.write((OutputStream)response.getOutputStream(), ApOrderVO.class).sheet("\u91c7\u8d2d\u7ed3\u7b97\u5355").doWrite(res.getRecords());
        }
        catch (IOException e) {
            log.error("\u91c7\u8d2d\u7ed3\u7b97\u5355\u5bfc\u51fa\u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
        }
    }

    public ApOrderServiceImpl(ApOrderDomainService apOrderDomainService, ApOrderDtlDomainService apOrderDtlDomainService, WorkflowRpcService workflowRpcService) {
        this.apOrderDomainService = apOrderDomainService;
        this.apOrderDtlDomainService = apOrderDtlDomainService;
        this.workflowRpcService = workflowRpcService;
    }
}

