/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.account;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.account.AccountBalanceConvert;
import com.elitesland.fin.application.facade.param.account.AccountBalanceParam;
import com.elitesland.fin.application.facade.vo.account.AccountBalanceVO;
import com.elitesland.fin.application.service.account.AccountBalanceService;
import com.elitesland.fin.dto.account.AccountBalanceCheckRpcDTO;
import com.elitesland.fin.dto.account.AccountBalanceRpcDTO;
import com.elitesland.fin.param.account.AccountBalanceCheckRpcParam;
import com.elitesland.fin.param.account.AccountBalanceRpcParam;
import com.elitesland.fin.service.account.AccountBalanceRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rpc/account/balance"})
public class AccountBalanceRpcServiceImpl
implements AccountBalanceRpcService {
    private static final Logger log = LoggerFactory.getLogger(AccountBalanceRpcServiceImpl.class);
    public final AccountBalanceService accountBalanceService;

    public ApiResult<List<AccountBalanceRpcDTO>> selectAccountBalanceByParam(AccountBalanceRpcParam accountRpcParam) {
        log.info("\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)accountRpcParam));
        AccountBalanceParam accountBalanceParam = AccountBalanceConvert.INSTANCE.rpcParamToParam(accountRpcParam);
        accountBalanceParam.setOptDocCheckFlag(false);
        List<AccountBalanceVO> accountBalanceVOList = this.accountBalanceService.selectAccountBalanceByParam(accountBalanceParam);
        if (CollectionUtil.isEmpty(accountBalanceVOList)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List accountBalanceRpcDTOList = accountBalanceVOList.stream().map(AccountBalanceConvert.INSTANCE::voToRpcDto).collect(Collectors.toList());
        log.info("\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u51fa\u53c2:{}", (Object)JSON.toJSONString(accountBalanceRpcDTOList));
        return ApiResult.ok(accountBalanceRpcDTOList);
    }

    public ApiResult<List<AccountBalanceCheckRpcDTO>> checkAccountBalanceByParam(List<AccountBalanceCheckRpcParam> checkRpcParamList) {
        log.info("\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u6821\u9a8c\u5165\u53c2:{}", (Object)JSON.toJSONString(checkRpcParamList));
        ArrayList<AccountBalanceCheckRpcDTO> checkRpcDTOList = new ArrayList<AccountBalanceCheckRpcDTO>();
        for (AccountBalanceCheckRpcParam accountRpcParam : checkRpcParamList) {
            if (Objects.isNull(accountRpcParam.getUuid())) {
                accountRpcParam.setUuid(IdFactory.generateLong());
            }
            AccountBalanceCheckRpcDTO accountBalanceCheckRpcDTO = new AccountBalanceCheckRpcDTO();
            accountBalanceCheckRpcDTO.setUuid(accountRpcParam.getUuid());
            if (Objects.isNull(accountRpcParam.getAmt())) {
                accountBalanceCheckRpcDTO.setCheckFlag(Boolean.valueOf(false));
                accountBalanceCheckRpcDTO.setErrorMsg("\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
                accountBalanceCheckRpcDTO.setAccountBalanceRpcDTOList(Collections.emptyList());
                checkRpcDTOList.add(accountBalanceCheckRpcDTO);
                continue;
            }
            try {
                AccountBalanceParam accountBalanceParam = AccountBalanceConvert.INSTANCE.checkRpcParamToParam(accountRpcParam);
                accountBalanceParam.setOptDocCheckFlag(true);
                List<AccountBalanceVO> accountBalanceVOList = this.accountBalanceService.selectAccountBalanceByParam(accountBalanceParam);
                if (CollectionUtil.isEmpty(accountBalanceVOList)) {
                    accountBalanceCheckRpcDTO.setCheckFlag(Boolean.valueOf(false));
                    accountBalanceCheckRpcDTO.setErrorMsg("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u8d26\u6237\u4f59\u989d\u6570\u636e");
                    accountBalanceCheckRpcDTO.setAccountBalanceRpcDTOList(Collections.emptyList());
                    checkRpcDTOList.add(accountBalanceCheckRpcDTO);
                    continue;
                }
                List accountBalanceRpcDTOList = accountBalanceVOList.stream().map(AccountBalanceConvert.INSTANCE::voToRpcDto).collect(Collectors.toList());
                accountBalanceCheckRpcDTO.setAccountBalanceRpcDTOList(accountBalanceRpcDTOList);
                BigDecimal thisBillAvailableAmountSum = accountBalanceRpcDTOList.stream().map(AccountBalanceRpcDTO::getThisBillAvailableAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (accountRpcParam.getAmt().compareTo(thisBillAvailableAmountSum) < 1) {
                    accountBalanceCheckRpcDTO.setCheckFlag(Boolean.valueOf(true));
                } else {
                    accountBalanceCheckRpcDTO.setCheckFlag(Boolean.valueOf(false));
                    accountBalanceCheckRpcDTO.setErrorMsg("\u91d1\u989d\u4e0d\u8db3");
                }
                checkRpcDTOList.add(accountBalanceCheckRpcDTO);
            }
            catch (Exception e) {
                accountBalanceCheckRpcDTO.setCheckFlag(Boolean.valueOf(false));
                accountBalanceCheckRpcDTO.setErrorMsg(e.getMessage());
                accountBalanceCheckRpcDTO.setAccountBalanceRpcDTOList(Collections.emptyList());
                checkRpcDTOList.add(accountBalanceCheckRpcDTO);
            }
        }
        log.info("\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u6821\u9a8c\u51fa\u53c2:{}", (Object)JSON.toJSONString(checkRpcDTOList));
        return ApiResult.ok(checkRpcDTOList);
    }

    public AccountBalanceRpcServiceImpl(AccountBalanceService accountBalanceService) {
        this.accountBalanceService = accountBalanceService;
    }
}

