/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.account;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.QAccountDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QAccountDO qAccountDO = QAccountDO.accountDO;
    private final AccountRepo accountRepo;

    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        JPAQuery<AccountVO> query = this.buildJPAQuery(accountPageParam);
        accountPageParam.setPaging(query);
        accountPageParam.fillOrders(query, this.qAccountDO);
        List fetch = query.fetch();
        return PagingVO.builder().total(query.fetchCount()).records(fetch).build();
    }

    public List<AccountVO> queryList(AccountPageParam accountPageParam) {
        JPAQuery<AccountVO> query = this.buildJPAQuery(accountPageParam);
        return query.fetch();
    }

    public JPAQuery<AccountVO> buildJPAQuery(AccountPageParam accountPageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderName())) {
            predicates.add(this.qAccountDO.accountHolderName.like("%" + accountPageParam.getAccountHolderName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderCode())) {
            predicates.add(this.qAccountDO.accountHolderCode.eq((Object)accountPageParam.getAccountHolderCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountName())) {
            predicates.add(this.qAccountDO.accountName.like("%" + accountPageParam.getAccountName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountType())) {
            predicates.add(this.qAccountDO.accountType.eq((Object)accountPageParam.getAccountType()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getState())) {
            predicates.add(this.qAccountDO.state.eq((Object)accountPageParam.getState()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountCode())) {
            predicates.add(this.qAccountDO.accountCode.like(StringUtil.buildLikeString(accountPageParam.getAccountCode())));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getSecOuCode())) {
            predicates.add(this.qAccountDO.secOuCode.eq((Object)accountPageParam.getSecOuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderNameCode())) {
            predicates.add(this.qAccountDO.accountHolderName.like(StringUtil.buildLikeString(accountPageParam.getAccountHolderNameCode())).or((Predicate)this.qAccountDO.accountHolderCode.like(StringUtil.buildLikeString(accountPageParam.getAccountHolderNameCode()))));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getIds())) {
            predicates.add(this.qAccountDO.id.in(accountPageParam.getIds()));
        }
        JPAQuery query = (JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates));
        return query;
    }

    public List<AccountVO> queryByAccounts(List<String> accounts, String type, String state) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)type)) {
            predicates.add(this.qAccountDO.accountType.eq((Object)type));
        }
        if (!CollectionUtils.isEmpty(accounts)) {
            predicates.add(this.qAccountDO.accountCode.in(accounts));
        }
        if (!StringUtils.isEmpty((CharSequence)state)) {
            predicates.add(this.qAccountDO.state.eq((Object)state));
        }
        return ((JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public Boolean updateAmtByCode(AccountParam accountParam) {
        Long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accountAmount, (Object)accountParam.getAccAmt()).set(this.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccOccAmt()).where(new Predicate[]{this.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAccountDO.id, this.qAccountDO.accountName, this.qAccountDO.accountCode, this.qAccountDO.accountType, this.qAccountDO.state, this.qAccountDO.createTime, this.qAccountDO.creator, this.qAccountDO.accountOccupancyAmount, this.qAccountDO.accountAmount.subtract(this.qAccountDO.accountOccupancyAmount).as("accAvaAmt"), this.qAccountDO.accountAmount, this.qAccountDO.accountAvailableAmount, this.qAccountDO.secOuCode, this.qAccountDO.secOuName, this.qAccountDO.secFranchiseeCode, this.qAccountDO.accountHolderType, this.qAccountDO.accountHolderName, this.qAccountDO.accountHolderCode, this.qAccountDO.remark})).from((EntityPath)this.qAccountDO);
    }

    public Long updateState(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set((Path)this.qAccountDO.state, (Object)accountParam.getState()).where(new Predicate[]{this.qAccountDO.id.in(accountParam.getIds())}).execute();
        return res;
    }

    public AccountVO get(Long id) {
        AccountVO accountVO = (AccountVO)((JPAQuery)this.select(AccountVO.class).where((Predicate)this.qAccountDO.id.eq((Object)id))).fetchOne();
        return accountVO;
    }

    public AccountVO getByCode(String accCode) {
        AccountVO res = (AccountVO)((JPAQuery)this.select(AccountVO.class).where((Predicate)this.qAccountDO.accountCode.eq((Object)accCode))).fetchOne();
        return res;
    }

    public Boolean updateOccAmtByCode(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccOccAmt()).where(new Predicate[]{this.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public Boolean updateAccAmtByCode(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accountAmount, (Object)accountParam.getAccAmt()).where(new Predicate[]{this.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public void updateAccountAmountByAccountCode(AccountParam accountParam) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qAccountDO);
        if (accountParam.getAccountAmount() != null) {
            jpaUpdateClause.set(this.qAccountDO.accountAmount, (Object)accountParam.getAccountAmount());
        }
        if (accountParam.getAccountOccupancyAmount() != null) {
            jpaUpdateClause.set(this.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccountOccupancyAmount());
        }
        if (accountParam.getAccountAvailableAmount() != null) {
            jpaUpdateClause.set(this.qAccountDO.accountAvailableAmount, (Object)accountParam.getAccountAvailableAmount());
        }
        jpaUpdateClause.where(new Predicate[]{this.qAccountDO.accountCode.eq((Object)accountParam.getAccountCode())}).execute();
    }

    public List<AccountDTO> getAccountByAccountParam(AccountParam param) {
        JPAQuery<AccountDTO> accountVOJPAQuery = this.select(AccountDTO.class);
        if (CollectionUtils.isNotEmpty(param.getAccountCodes())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountCode.in(param.getAccountCodes()));
        }
        if (CollectionUtils.isNotEmpty(param.getAccountHolderNames())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountHolderName.in(param.getAccountHolderNames()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountCode())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountCode.eq((Object)param.getAccountCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountName())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountName.eq((Object)param.getAccountName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountHolderName())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountHolderName.eq((Object)param.getAccountHolderName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountHolderCode())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountHolderCode.eq((Object)param.getAccountHolderCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSecOuCode())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.secOuCode.eq((Object)param.getSecOuCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountType())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountType.eq((Object)param.getAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getState())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.state.eq((Object)param.getState()));
        }
        return accountVOJPAQuery.fetch();
    }

    public AccountDO findByAccountCode(String accountCode) {
        List<AccountDO> accountDOList = this.accountRepo.findAllByAccountCode(accountCode);
        Assert.notEmpty(accountDOList, (String)"\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((accountDOList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountDO accountDO = accountDOList.get(0);
        Assert.equals((Object)accountDO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return accountDOList.get(0);
    }

    public AccountVO getVOByCode(String accCode) {
        List accountVoList = ((JPAQuery)this.select(AccountVO.class).where((Predicate)this.qAccountDO.accountCode.eq((Object)accCode))).fetch();
        Assert.notEmpty((Iterable)accountVoList, (String)"\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((accountVoList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountVO accountVO = (AccountVO)accountVoList.get(0);
        Assert.equals((Object)accountVO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return accountVO;
    }

    public AccountRepoProc(JPAQueryFactory jpaQueryFactory, AccountRepo accountRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.accountRepo = accountRepo;
    }
}

