package com.elitesland.fin.application.service.unionpay.interceptor;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author eric.hao
 * @since 2023/06/08
 */
@Configuration
public class UnionPayMvcConfigurer implements WebMvcConfigurer {

    @Bean
    public UnionPayAuthInterceptor unionPayAuthInterceptor() {
        return new UnionPayAuthInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(unionPayAuthInterceptor()).addPathPatterns("/unionpay/**");
    }
}
