package com.elitesland.fin.infr.dto.saleinv;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author chaofeng.xia
 * @since 2025/8/8
 */
@Data
public class SaleInvAppDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = 1731738038357377852L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("申请单号")
    private String applyNo;

    @ApiModelProperty("含税总金额(开票申请金额)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;

    @ApiModelProperty("对账申请时间")
    private LocalDateTime recApplyTime;

    @ApiModelProperty("根单据下单时间从")
    private LocalDateTime rootDocTimeFrom;

    @ApiModelProperty("根单据下单时间至")
    private LocalDateTime rootDocTimeTo;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-fin", mod = "INVOICE_STATUS")
    private String orderState;
    private String orderStateName;

    @ApiModelProperty(value = "发票类型")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty(value = "开票抬头类型")
    @SysCode(sys = "yst-supp", mod = "INV_TITLE_TYPE")
    private String invTitleType;
    private String invTitleTypeName;

    @ApiModelProperty("开票邮箱")
    private String invEmail;

    @ApiModelProperty("开票联系人")
    private String invPicName;

    @ApiModelProperty("开票联系人电话")
    private String invPicPhone;

    @ApiModelProperty("税号")
    private String custTaxNo;

    @ApiModelProperty("银行")
    private String custBank;

    @ApiModelProperty("银行账号")
    private String custBankAcc;

    @ApiModelProperty("地址")
    private String custAdd;

    @ApiModelProperty("发票抬头")
    private String custInvTitle;
}
