package com.elitesland.fin.provider.creditaccount;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSaveParam;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.dto.creditaccount.CreditAccountRpcDTO;
import com.elitesland.fin.param.creditaccount.CreditAccountRpcParam;
import com.elitesland.fin.service.creditaccount.CreditAccountRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.service.account
 * @date 2023/3/7 13:56
 */

@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + CreditAccountRpcService.PATH)
@Slf4j
public class CreditAccountRpcServiceImpl implements CreditAccountRpcService {


    private final CreditAccountService creditAccountService;

    @Override
    public ApiResult<Void> createCreditAccounts(List<CreditAccountRpcParam> param){
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public ApiResult<Object> createCreditAccount(CreditAccountRpcParam param){
        log.info("财务创建信用账户rpc接口,参数:{}", JSON.toJSONString(param));
        CreditAccountSaveParam creditAccountSaveParam = CreditAccountConvert.INSTANCE.rpcParam2Param(param);
        creditAccountService.saveOrUpdate(creditAccountSaveParam);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<CreditAccountRpcDTO>> queryCreditAccountCode(CreditAccountRpcParam param) {
        log.info("财务查询信用账户rpc接口,参数:{}", JSON.toJSONString(param));
        List<CreditAccountDTO> creditAccountDTOS = creditAccountService.getAccountByAccountParam(CreditAccountConvert.INSTANCE.rpc2Param(param));
        return ApiResult.ok(CreditAccountConvert.INSTANCE.dtos2RpcDtos(creditAccountDTOS));

    }

    @Override
    @Transactional
    public ApiResult<Object> updateRelateAccount(List<CreditAccountRpcParam> params) {
        log.info("更新扫呗账号关联账号开始，参数：{}", JSON.toJSONString(params));
        if (CollectionUtils.isEmpty(params)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "参数不能为空");
        }
        params.forEach(param->{
            creditAccountService.updateRelateAccount(param.getObjectCode(), param.getRelateAccountCode());
        });
        log.info("更新扫呗账号关联账号结束");
        return ApiResult.ok();
    }

}
