package com.elitesland.fin.repo.creditaccount;

import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository
public interface CreditAccountRepo extends JpaRepository<CreditAccountDO, Long>, QuerydslPredicateExecutor<CreditAccountDO> {


    boolean existsByCreditAccountName(String creditAccountName);

    boolean existsByCreditAccountCode(String creditAccountCode);

    boolean existsByObjectCodeAndOuCode(String objectCode,String ouCode);

    boolean existsByObjectCode(String objectCode);

    CreditAccountDO findByObjectCodeAndOuCode(String objectCode,String ouCode);

    CreditAccountDO findByObjectCode(String objectCode);

    CreditAccountDO findByCreditAccountName(String creditAccountName);

    List<CreditAccountDO> findByObjectCodeInAndOuCode(List<String> objectCodeList,String ouCode);

    List<CreditAccountDO> findByObjectCodeIn(List<String> objectCodeList);

    List<CreditAccountDO> findAllByCreditAccountCode(String accountCode);

    List<CreditAccountDO> findAllByObjectCode(String objectCode);

    @Transactional
    @Modifying
    @Query(value = "update credit_account set status = ?1 where id in ?2", nativeQuery = true)
    void updateStatusByIds(String status, List<Long> id);

    boolean existsByObjectCodeInAndOuCode(List<String> custCodes,String ouCode);
    @Modifying
    @Query(value = "update credit_account  set credit_account_occupancy_limit =credit_account_occupancy_limit+:creditAccountOccupancy,credit_account_available_limit =credit_account_available_limit-:creditAccountOccupancy\n" +
            "where id=:id and credit_account_available_limit >= :creditAccountOccupancy", nativeQuery = true)
    int updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(long id, BigDecimal creditAccountOccupancy);

    @Modifying
    @Query(value = "update credit_account  set credit_account_limit =credit_account_limit + :amount,credit_account_available_limit =credit_account_available_limit + :amount\n" +
            "where id=:id ", nativeQuery = true)
    int updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount);

    @Modifying
    @Query(value = "update credit_account  set credit_account_limit =credit_account_limit - :amount,credit_account_available_limit =credit_account_available_limit - :amount\n" +
            "where id=:id ", nativeQuery = true)
    int updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount);

    @Modifying
    @Query(value = "update credit_account  set credit_account_occupancy_limit =credit_account_occupancy_limit - :amount,credit_account_available_limit =credit_account_available_limit + :amount\n" +
            "where id=:id ", nativeQuery = true)
    int updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount);

    @Modifying
    @Query(value = "update credit_account set credit_account_used_limit =credit_account_used_limit + :amount,credit_account_available_limit =credit_account_available_limit - :amount\n" +
            "where id=:id ", nativeQuery = true)
    int updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount);

    @Modifying
    @Query(value = "update credit_account set credit_account_used_limit =credit_account_used_limit - :amount,credit_account_available_limit =credit_account_available_limit + :amount\n" +
            "where id=:id ", nativeQuery = true)
    int updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount);

}
