/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.aisino.vo.param;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedInitialRespVO;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedPayload;
import com.elitesland.fin.infinity.aisino.vo.param.account.BizOrderUploadDatum;
import com.elitesland.fin.infinity.aisino.vo.param.account.BizOrderUploadRequest;
import com.elitesland.fin.infinity.aisino.vo.param.account.Detail;
import com.elitesland.fin.infinity.aisino.vo.param.invoice.AisinoRedOpenParam;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AisinoApplyPayload {
    private String APPID;
    private String DATA;
    private String USERNAME;

    public static AisinoApplyPayload convert(InvoiceApplySaveParam saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        BizOrderUploadDatum row = new BizOrderUploadDatum();
        row.setFPQQLSH(saveParam.getSaleTaxNo() + saveParam.getApplyNo());
        BizOrderUploadRequest request = new BizOrderUploadRequest();
        request.setDJH(saveParam.getApplyNo());
        request.setGMFMC(saveParam.getInvCustCode());
        request.setGMFSH(saveParam.getCustTaxNo());
        request.setGMFYH(saveParam.getInvBankNo());
        request.setGMFYHZH(saveParam.getBankAccount());
        request.setGMFRYXZ("1");
        request.setKPLX("0");
        if (saveParam.getInvType().equals("VANA")) {
            request.setFPZLDM("01");
        } else if (saveParam.getInvType().equals("VANSP")) {
            request.setFPZLDM("02");
        }
        request.setJSHJ(AisinoApplyPayload.scale(saveParam.getTotalAmt()));
        if (!Objects.equals(request.getGMFRYXZ(), "1")) {
            request.setBZ("\u8d2d\u4e70\u65b9\u5730\u5740\uff1a" + saveParam.getCustAdd() + ";\u7535\u8bdd\uff1a" + saveParam.getPhone() + ";\u8d2d\u65b9\u5f00\u6237\u94f6\u884c\uff1a" + saveParam.getCustBank() + ";\u94f6\u884c\u8d26\u53f7\uff1a" + saveParam.getCustBankAcc());
        }
        request.setXHFKHH(saveParam.getSaleBank());
        request.setXHFYHZH(saveParam.getSaleBankAcc());
        BigDecimal netAmt = BigDecimal.ZERO;
        BigDecimal taxAmt = BigDecimal.ZERO;
        ArrayList<Detail> details = new ArrayList<Detail>();
        int lineNo = 1;
        for (InvoiceDetailSaveParam detail : saveParam.getDetails()) {
            netAmt = netAmt.add(detail.getExclTaxAmt());
            taxAmt = taxAmt.add(detail.getTaxAmt());
            Detail drow = new Detail();
            drow.setXH(Integer.toString(lineNo));
            drow.setSPBM(detail.getItemCode());
            drow.setSPMC(detail.getItemName());
            drow.setSPJM(detail.getTaxCode());
            drow.setGGXH(detail.getItemType());
            drow.setJLDW(detail.getUom());
            drow.setSLV(detail.getTaxRate().toString());
            drow.setSL(Objects.isNull(detail.getQty()) ? null : detail.getQty().toString());
            drow.setDJ(AisinoApplyPayload.scale(detail.getPrice()));
            drow.setJE(AisinoApplyPayload.scale(detail.getTotalAmt()));
            drow.setSE(AisinoApplyPayload.scale(detail.getTaxAmt()));
            drow.setKCE("0");
            if (detail.getDiscountAmt() != null && detail.getDiscountAmt().compareTo(BigDecimal.ZERO) > 0) {
                drow.setHXZ("2");
            } else {
                drow.setHXZ("0");
            }
            drow.setHSBZ("1");
            details.add(drow);
            ++lineNo;
            if (detail.getDiscountAmt() == null || detail.getDiscountAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            Detail discountRow = new Detail();
            discountRow.setXH(Integer.toString(lineNo));
            discountRow.setSPBM(detail.getItemCode());
            discountRow.setSPMC(detail.getItemName());
            discountRow.setSPJM(detail.getTaxCode());
            discountRow.setGGXH("");
            discountRow.setJLDW("");
            discountRow.setSLV(detail.getTaxRate().toString());
            discountRow.setSL("");
            discountRow.setDJ("");
            discountRow.setJE(AisinoApplyPayload.scale(detail.getTotalAmt().negate()));
            discountRow.setSE(AisinoApplyPayload.scale(detail.getTaxAmt().negate()));
            discountRow.setKCE("");
            discountRow.setHXZ("1");
            details.add(discountRow);
            ++lineNo;
        }
        request.setHJJE(AisinoApplyPayload.scale(netAmt));
        request.setHJSE(AisinoApplyPayload.scale(taxAmt));
        request.setMXLIST(details);
        row.setREQUEST(request);
        String encryptedData = AisinoApplyPayload.getEncryptedData(JSONObject.toJSONString((Object)row));
        payload.setDATA(encryptedData);
        return payload;
    }

    public static AisinoApplyPayload convertRedInitial(InvoiceRedApplySaveParam saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        AisinoRedPayload row = new AisinoRedPayload();
        row.setLZFPQDHM(saveParam.getOriginApplyNo());
        row.setGMFNSRSBH(saveParam.getCustTaxNo());
        row.setXSFNSRSBH(saveParam.getSaleTaxNo());
        row.setLZKPRQ(saveParam.getInvDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        row.setKPFNSRSBH(saveParam.getSaleTaxNo());
        row.setGJBQ("1");
        row.setTDYSLXDM("");
        if (saveParam.getInvType().equals("VANA")) {
            row.setFPLXDM("81");
        } else if (saveParam.getInvType().equals("VANSP")) {
            row.setFPLXDM("82");
        }
        row.setLZFPHM("");
        row.setLZFPDM("");
        row.setFPLYDM("2");
        String encryptedData = AisinoApplyPayload.getEncryptedData(JSONObject.toJSONString((Object)row));
        payload.setDATA(encryptedData);
        return payload;
    }

    public static AisinoApplyPayload convertRedSave(InvoiceRedInitialRespVO saveParam) {
        return AisinoApplyPayload.getAisinoApplyPayload(JSONObject.toJSONString((Object)saveParam));
    }

    public static AisinoApplyPayload convertRedOpen(AisinoRedOpenParam saveParam) {
        return AisinoApplyPayload.getAisinoApplyPayload(JSONObject.toJSONString((Object)saveParam));
    }

    @NotNull
    private static AisinoApplyPayload getAisinoApplyPayload(String saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        String encryptedData = AisinoApplyPayload.getEncryptedData(saveParam);
        payload.setDATA(encryptedData);
        return payload;
    }

    @NotNull
    private static String getEncryptedData(String row) {
        String key = "12345678";
        byte[] encryptedBytes = InvoiceIssueUtil.encrypt(row.getBytes(), key);
        if (encryptedBytes == null) {
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25,\u52a0\u5bc6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6570\u636e:" + row);
        }
        return InvoiceIssueUtil.byteToHexString(encryptedBytes);
    }

    private static String scale(BigDecimal num) {
        return num.setScale(2, RoundingMode.HALF_UP).toString();
    }

    public String getAPPID() {
        return this.APPID;
    }

    public String getDATA() {
        return this.DATA;
    }

    public String getUSERNAME() {
        return this.USERNAME;
    }

    public void setAPPID(String APPID) {
        this.APPID = APPID;
    }

    public void setDATA(String DATA) {
        this.DATA = DATA;
    }

    public void setUSERNAME(String USERNAME) {
        this.USERNAME = USERNAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisinoApplyPayload)) {
            return false;
        }
        AisinoApplyPayload other = (AisinoApplyPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$APPID = this.getAPPID();
        String other$APPID = other.getAPPID();
        if (this$APPID == null ? other$APPID != null : !this$APPID.equals(other$APPID)) {
            return false;
        }
        String this$DATA = this.getDATA();
        String other$DATA = other.getDATA();
        if (this$DATA == null ? other$DATA != null : !this$DATA.equals(other$DATA)) {
            return false;
        }
        String this$USERNAME = this.getUSERNAME();
        String other$USERNAME = other.getUSERNAME();
        return !(this$USERNAME == null ? other$USERNAME != null : !this$USERNAME.equals(other$USERNAME));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisinoApplyPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $APPID = this.getAPPID();
        result = result * 59 + ($APPID == null ? 43 : $APPID.hashCode());
        String $DATA = this.getDATA();
        result = result * 59 + ($DATA == null ? 43 : $DATA.hashCode());
        String $USERNAME = this.getUSERNAME();
        result = result * 59 + ($USERNAME == null ? 43 : $USERNAME.hashCode());
        return result;
    }

    public String toString() {
        return "AisinoApplyPayload(APPID=" + this.getAPPID() + ", DATA=" + this.getDATA() + ", USERNAME=" + this.getUSERNAME() + ")";
    }
}

