package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.invoice.ApplyRePushParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceDtlDomainService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.writeoff.RmiUdcService;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhiMing
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InvoiceServiceImpl implements InvoiceService {

    private final InvoiceApplyService invoiceApplyService;
    //    private final StoreRpcService storeRpcService;
    //    private final InvoiceRpcService invoiceRpcService;
//    private final TsOrgAddrRpcService orgAddrRpcService;
    private final InvoiceSaveService invoiceSaveService;
    private final InvoiceRedraftRepo invoiceRedraftRepo;
    //    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvService saleInvService;
    //    private final FranchiseeRpcService franchiseeRpcService;
//    private final UserWhRoleRpcService userWhRoleRpcService;
//    private final UserDeptRpcService userDeptRpcService;
//    private final UserStoreRpcService userStoreRpcService;
    private final InvoiceDtlDomainService invoiceDtlDomainService;
    //    private final TsSaleInvdDtlRepo tsSaleInvdDtlRepo;
    private final SaleInvDtlRepo tsSaleInvDtlRepo;
    private final ItmItemRpcService itmItemRpcService;
    @Autowired
    private AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;
    @Autowired
    private RmiUdcService rmiSysUdcRpcService;

    @Override
    public long create(InvoiceApplyParam param) {
        //参数校验
        this.checeInvParam(param);
        // 验重
        InvoiceQueryParam queryParam = new InvoiceQueryParam();
        queryParam.setSourceDocId(param.getIds());
        List<InvoiceApplyRpcDTO> applyRpcDTO = invoiceApplyService.queryIdBySource(queryParam);
        if (CollUtil.isNotEmpty(applyRpcDTO)) {
            throw new BusinessException("单据已开票，不能重复操作");
        }
        List<InvoiceSaveVO> save = invoiceSaveService.save(param);
        if (!CollUtil.isEmpty(save)) {
            return save.get(0).getApplyId();
        }
        return 0L;
    }

    @Transactional
    @Override
    public Long redraft(String applyNo) {
        InvoiceRedraftDO invRedraftDO = invoiceRedraftRepo.findByOrigApplyNo(applyNo);
        if (!ObjectUtils.isEmpty(invRedraftDO) && !ObjectUtils.isEmpty(invRedraftDO.getWorkflowProcInstStatus())) {
            throw new BusinessException("存在未完结的重新开票审批");
        }
        // 不做特殊校验，直接开票
        InvoiceApplyRpcDTO applyRpcDTO = invoiceApplyService.queryIdByApplyNo(applyNo);
        Assert.notNull(applyRpcDTO.getApplyId(), applyNo + " 单据不存在");
        /*if (!applyRpcDTO.isRedState()) {
            throw new BusinessException("重新开票失败：没有发票或发票没有红冲");
        }*/
        //生成重新开票记录
        InvoiceRedraftDO invoiceRedraftDO = this.saveInvoiceRedraft(applyRpcDTO);
        return invoiceRedraftDO.getId();
    }

    /**
     * 开票查询发票抬头 根据加盟商code查询
     *
     * @return
     */
//    @Override
//    public List<InvoiceRpcDTO> invQuery(List<ApplyInvoiceParam> applyInvoiceParam) {
//        Assert.notEmpty(applyInvoiceParam, "入参为空!");
//        //取出门店list
//        List<String> storeCode = applyInvoiceParam.stream().map(ApplyInvoiceParam::getStoreCode).collect(Collectors.toList());
//        //校验1 校验传递的多个开票主体是否是同一加盟商
//        // 使用流去重，并计算总数
//        List<String> franchiseeCode = applyInvoiceParam.stream()
//                .map(ApplyInvoiceParam::getFranchiseeCode)
//                .distinct().collect(Collectors.toList());
//        if (franchiseeCode.size() > 1) {
//            throw new BusinessException("不同加盟商不能同时开票");
//        }
//        //校验二 付款记录没有门店 直接返回加盟商开票主体
//        List<String> storeCodeList = applyInvoiceParam.stream().filter(a -> storeCode != null).map(ApplyInvoiceParam::getStoreCode).collect(Collectors.toList());
//        if (CollUtil.isEmpty(storeCodeList)) {
//            List<TsInvoiceRpcDTO> tsInvoiceRpcDTOS = invoiceRpcService.listByFranCode(franchiseeCode.get(0));
//            List<InvoiceRpcDTO> franchiseeList = InvoiceConvert.INSTANCE.rpcDtos2TsDtos(tsInvoiceRpcDTOS);
//            return franchiseeList;
//        }
//        //校验三 都有门店 看开票主体是不是一样的，如果都是一样的 返回门店的主体信息和加盟商的主体信息
//        //门店code转门店id
//        var storeRpcDTOList = storeRpcService.findByCode(storeCode);
//        //新增校验 查询门店的银行信息，若银行信息不一致，也无法进行开票
//        Set<String> bankCodes = new HashSet<>();
//        storeRpcDTOList.forEach(
//                storeRpcDTO -> {
//                    TsOrgAddrBankAccParam accParam = new TsOrgAddrBankAccParam();
//                    accParam.setAddrNo(storeRpcDTO.getAddrNo());
//                    List<TsOrgAddrBankAccRpcDTO> byAddrNo = orgAddrRpcService.findByAddrNo(accParam);
//                    if (!CollectionUtils.isEmpty(byAddrNo)) {
//                        if (byAddrNo.size() > 1) {
//                            throw new BusinessException(storeRpcDTO.getStoreCode() + "此门店银行信息不唯一");
//                        }
//                        bankCodes.add(byAddrNo.get(0).getBankCode());
//                    }
//                }
//        );
//        if (!CollectionUtils.isEmpty(bankCodes) && bankCodes.size() > 1) {
//            throw new BusinessException("多家门店的银行信息不同不能同时开票");
//        }
//        List<Long> storeIdList = storeRpcDTOList.stream().map(StoreRpcDTO::getStoreId).collect(Collectors.toList());
//        //查询门店
//        var storeInvoiceList = storeInvoiceList(storeIdList, franchiseeCode.get(0));
//        List<InvoiceRpcDTO> invoiceRpcDTOList = Lists.newArrayList();
//        Set<String> checkedInvoices = new HashSet<>();
//        for (InvoiceRpcDTO invoiceRpcDTO : storeInvoiceList) {
//            String taxNo = invoiceRpcDTO.getTaxNo();
//            String invTitle = invoiceRpcDTO.getInvTitle();
//            String key = taxNo + "-" + invTitle;
//
//            if (!checkedInvoices.contains(key)) {
//                invoiceRpcDTOList.add(invoiceRpcDTO);
//                checkedInvoices.add(key);
//            }
//        }
//        //查询加盟商
//        List<TsInvoiceRpcDTO> tsInvoiceRpcDTOS = invoiceRpcService.listByFranCode(franchiseeCode.get(0));
//        List<InvoiceRpcDTO> franchiseeList = InvoiceConvert.INSTANCE.rpcDtos2TsDtos(tsInvoiceRpcDTOS);
//        List<InvoiceRpcDTO> franchiseeDistinct = Lists.newArrayList();
//        //过滤空数据
//        for (InvoiceRpcDTO invoiceRpcDTO : franchiseeList) {
//            if (StringUtils.isNotBlank(invoiceRpcDTO.getInvTitle())) {
//                InvoiceRpcDTO invoice = new InvoiceRpcDTO();
//                BeanUtils.copyProperties(invoiceRpcDTO, invoice);
//                franchiseeDistinct.add(invoice);
//            }
//        }
//        if (CollUtil.isNotEmpty(invoiceRpcDTOList)) {
//            //合并
//            List<InvoiceRpcDTO> mergedList = Lists.newArrayList();
//            mergedList.addAll(invoiceRpcDTOList);
//            for (InvoiceRpcDTO invoice : franchiseeDistinct) {
//                if (StringUtils.isBlank(invoice.getInvTitle())) {
//                    continue;
//                }
//                boolean duplicateFound = false;
//                for (InvoiceRpcDTO mergedInvoice : mergedList) {
//                    if (mergedInvoice.getInvTitle().equals(invoice.getInvTitle()) &&
//                            mergedInvoice.getTaxNo().equals(invoice.getTaxNo())) {
//                        duplicateFound = true;
//                        break;
//                    }
//                }
//                if (!duplicateFound) {
//                    mergedList.add(invoice);
//                }
//            }
//            return mergedList;
//        }
//        //有店有主体有门店没开票主体 ，门店的开票主体是否相同(先考虑)，只返回加盟商的开票主体
//        if (storeCode.size() != invoiceRpcDTOList.size()) {
//            //直接返回加盟商开票主体
//            return franchiseeDistinct;
//        }
//        return new ArrayList<>();
//    }

//    @Override
//    public PagingVO<SaleInvoiceVO> page(SaleInvPageParam param) {
//        if (ObjectUtils.isEmpty(param.getCustCodeList())) {
//            Long userId = IamUserUtil.currentUserId();
//            FranchiseeRpcDTO franchisee = franchiseeRpcService.franchiseeByUserId(userId);
//            var deptList = userDeptRpcService.queryUserDeptByUser(List.of(userId));
//
//            if (!ObjectUtils.isEmpty(franchisee)) {
//                //查询子加盟商信息
//                var subFranchisee = franchiseeRpcService.subFranchiseeByCodes(Collections.singletonList(franchisee.getFranchiseeCode()));
//                List<String> subFranchiseeCode = Lists.newArrayList();
//                if (CollUtil.isNotEmpty(subFranchisee)) {
//                    var fran = subFranchisee.stream().map(FranchiseeSubRpcDTO::getFranchiseeSubCode).collect(Collectors.toList());
//                    if (CollUtil.isNotEmpty(fran)) {
//                        subFranchiseeCode.addAll(fran);
//                    }
//                }
//                List<String> code = Lists.newArrayList();
//                code.add(franchisee.getFranchiseeCode());
//                if (CollUtil.isNotEmpty(subFranchiseeCode)) {
//                    code.addAll(subFranchiseeCode);
//                }
//                param.setCustCodeList(code);
//            } else if (CollUtil.isNotEmpty(deptList)) {
//                var storeList = userStoreRpcService.search(IamUserUtil.currentUserId());
//                //id转code
//                var store = storeRpcService.findById(storeList.stream().map(UserStoreResp::getStoreId).distinct().collect(Collectors.toList()));
//                param.setStoreCodeList(store.stream().map(StoreRpcDTO::getStoreCode).collect(Collectors.toList()));
//            }
//        }
//        if (CollUtil.isEmpty(param.getCustCodeList())) {
//            //加盟商渠道过滤
//            var role = userWhRoleRpcService.query(IamUserUtil.currentUserId());
//            if (role != null && CollUtil.isNotEmpty(role.getChannelType())) {
//                List<String> franchiseeCode = Lists.newArrayList();
//                //查询加盟商
//                role.getChannelType().forEach(f -> {
//                    var franchiseeUNIT = franchiseeRpcService.franchiseeByChannelType(f).stream().map(FranchiseeRpcDTO::getFranchiseeCode).collect(Collectors.toList());
//                    if (CollUtil.isNotEmpty(franchiseeUNIT)) {
//                        franchiseeCode.addAll(franchiseeUNIT);
//                    }
//
//                });
//                if (CollUtil.isNotEmpty(param.getCustCodeList())) {
//                    franchiseeCode.addAll(param.getCustCodeList());
//                }
//                if (CollUtil.isNotEmpty(franchiseeCode)) {
//                    param.setCustCodeList(franchiseeCode);
//                }
//            }
//        }
//        PagingVO<SaleInvVO> page = saleInvService.page(param);
//        List<SaleInvVO> records = page.getRecords();
//        List<SaleInvoiceVO> result = new ArrayList<>();
//        if (!CollectionUtils.isEmpty(records)) {
//            List<Long> collect = records.stream().map(SaleInvVO::getId).collect(Collectors.toList());
//            List<SaleInvdDtlDO> allByMasIdIn = tsSaleInvdDtlRepo.findAllByMasIdIn(collect);
//            Map<Long, String> map = allByMasIdIn.stream().collect(Collectors.toMap(SaleInvdDtlDO::getMasId, SaleInvdDtlDO::getInvPdfUrl));
//            for (SaleInvVO record : records) {
//                SaleInvoiceVO saleInvoiceVO = new SaleInvoiceVO();
//                org.springframework.beans.BeanUtils.copyProperties(record, saleInvoiceVO);
//                if (!CollectionUtils.isEmpty(map)) {
//                    String url = map.get(record.getId());
//                    saleInvoiceVO.setInvPdfUrl(url);
//                }
//                result.add(saleInvoiceVO);
//            }
//        }
//
//        PagingVO<SaleInvoiceVO> pagingVO = new PagingVO<>();
//        pagingVO.setRecords(result);
//        pagingVO.setTotal(page.getTotal());
//        return pagingVO;
//    }
    @Override
    public void rePush(ApplyRePushParam param) {
        List<SaleInvDO> applyList = saleInvRepo.findByApplyNoIn(param.getApplyNoList());
        if (CollectionUtils.isEmpty(applyList)) {
            throw new BusinessException("未找到单据");
        }
        List<SaleInvDO> errorInfo = applyList.stream()
                .filter(v -> Objects.isNull(v.getExternalStatus()) || v.getExternalStatus().equals("处理成功"))
                .toList();

        if (!CollectionUtils.isEmpty(errorInfo)) {
            List<String> collect = errorInfo.stream().map(SaleInvDO::getApplyNo).toList();
            throw new BusinessException("存在无法推送的数据，推送失败，申请单号为：" + collect);
        }

        applyList.forEach(apply -> {
            InvoiceApplySaveParam invoiceApplySaveParam = new InvoiceApplySaveParam();
            org.springframework.beans.BeanUtils.copyProperties(apply, invoiceApplySaveParam);
            List<SaleInvDtlDO> allByMasIdIn = tsSaleInvDtlRepo.findAllByMasIdIn(new ArrayList<>() {{
                add(apply.getId());
            }});

            List<InvoiceDetailSaveParam> detail = new ArrayList<>();
            allByMasIdIn.forEach(v -> {
                InvoiceDetailSaveParam invoiceDetailSaveParam = new InvoiceDetailSaveParam();
                org.springframework.beans.BeanUtils.copyProperties(v, invoiceDetailSaveParam);
                invoiceDetailSaveParam.setLineNo(v.getSourceLine());
                detail.add(invoiceDetailSaveParam);
            });

            invoiceApplySaveParam.setDetails(detail);
            abstractInvoiceSaveService.aisinoApplyMethod(invoiceApplySaveParam, apply.getApplyNo());
        });
    }

    /**
     * 获取指定主表ID的销售明细列表。
     *
     * @param masId 主表ID，用于查询相关的销售明细数据。
     * @return 返回销售明细的VO（值对象）列表，这个列表是通过DTO（数据传输对象）转换而来的。
     */
    @Override
    public List<SaleInvDtlVO> getDtlList(Long masId) {
        try {
            // 从发票明细领域服务获取指定主表ID的销售明细DTO列表
            List<SaleInvDtlDTO> list = invoiceDtlDomainService.getList(masId);

            // 获取商品编码和商品名称
            Set<String> itemCodeList = list.stream().map(SaleInvDtlDTO::getItemCode).collect(Collectors.toSet());
            Set<Long> itemIdList = list.stream().map(SaleInvDtlDTO::getItemId).collect(Collectors.toSet());

            ItmItemRpcDtoParam itmItemParam = new ItmItemRpcDtoParam();
            itmItemParam.setItemCodes(new ArrayList<>(itemCodeList));
            itmItemParam.setItemIds(new ArrayList<>(itemIdList));
            List<ItmItemRpcDTO> itmItemResps = itmItemRpcService.findItemRpcDtoByParam(itmItemParam);

            Map<String, String> itemCodeAndNameMap = itmItemResps.stream()
                    .collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, ItmItemRpcDTO::getItemName));

            Map<String, String> itemNameAndCodeMap = itemCodeAndNameMap.entrySet().stream()
                    .collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));

            // 获取税收分类编码UDC信息
            Map<String, String> udcValues = org.apache.commons.lang3.ObjectUtils.defaultIfNull(
                    rmiSysUdcRpcService.getUdcMapByUdcCode("yst-supp", "TAXONOMY_CODE"),
                    new HashMap<>()
            );

            // 设置税收分类名称
            list = list.stream().peek(v -> {
                String taxName = udcValues.getOrDefault(v.getTaxCode(), "");
                v.setTaxName(taxName);
                if (!ObjectUtils.isEmpty(v.getItemCode()) && ObjectUtils.isEmpty(v.getItemName())) {
                    String itemName = itemCodeAndNameMap.getOrDefault(v.getItemCode(), v.getItemName());
                    v.setItemName(itemName);
                } else if (!ObjectUtils.isEmpty(v.getItemName()) && ObjectUtils.isEmpty(v.getItemCode())) {
                    String itemCode = itemNameAndCodeMap.getOrDefault(v.getItemName(), v.getItemCode());
                    v.setItemCode(itemCode);
                }
            }).collect(Collectors.toList());

            // 将获取到的DTO列表转换为VO列表，以供前端使用
            List<SaleInvDtlVO> res = SaleInvConvert.INSTANCE.convertListVO(list);
            return res;
        } catch (Exception e) {
            // 日志记录异常，可以进一步细化异常处理，如重试逻辑、返回特定错误信息等
            log.error("Fetching sale details failed" + e.getMessage(), e);
            throw new BusinessException("Fetching sale details failed", e);
        }
    }
//
//    public List<InvoiceRpcDTO> storeInvoiceList(List<Long> storeId, String franchiseeCode) {
//        List<InvoiceRpcDTO> invoiceRpcDTOList = storeRpcService.franchiseeCodeQueryInvoice(storeId, franchiseeCode);
//        return invoiceRpcDTOList;
//    }

    private InvoiceRedraftDO saveInvoiceRedraft(InvoiceApplyRpcDTO applyRpcDTO) {
        SaleInvDO saleInvDO = saleInvRepo.findByApplyNo(applyRpcDTO.getApplyNo());
        List<SaleInvdDtlVO> saleInvdDtlVOs = saleInvService.getInvdLists(saleInvDO.getId());
        if (!CollectionUtils.isEmpty(saleInvdDtlVOs)) {
            SaleInvdDtlVO saleInvdDtlVO = saleInvdDtlVOs.get(0);
            InvoiceRedraftDO invoiceRedraftDO = new InvoiceRedraftDO();
            invoiceRedraftDO.setOrigApplyNo(applyRpcDTO.getApplyNo());
            invoiceRedraftDO.setInvoiceNo(saleInvdDtlVO.getInvNo());
            invoiceRedraftDO.setSerialNo(saleInvdDtlVO.getFlowNo());
            invoiceRedraftDO.setInvoiceAmt(saleInvdDtlVO.getTotalAmt());
            invoiceRedraftDO.setInvoiceDate(saleInvdDtlVO.getInvDate());
            invoiceRedraftDO.setInvoiceType(saleInvDO.getInvType());
            invoiceRedraftDO.setWorkflowProcInstStatus(ProcInstStatus.NOTSUBMIT);

            // 设计加盟商和门店信息
            invoiceRedraftDO.setCustCode(saleInvDO.getCustCode());
//            invoiceRedraftDO.setStoreCode(saleInvDO.getStoreCode());
            invoiceRedraftRepo.save(invoiceRedraftDO);
            return invoiceRedraftDO;
        } else {
            throw new BusinessException("当前销售发票无开票明细" + applyRpcDTO.getApplyId());
        }
    }

    /**
     * 开票参数校验
     *
     * @param param
     */
    public void checeInvParam(InvoiceApplyParam param) {
        Assert.notNull(param.getInvType(), "发票类型不能为空");
        Assert.notNull(param.getCustInvTitle(), "开票抬头不能为空");
        Assert.notNull(param.getCustTaxNo(), "税号不能为空");
    }

}
