package com.elitesland.fin.domain.entity.rectype;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:10
 */

@Entity
@Table(name="rec_type")
@org.hibernate.annotations.Table(appliesTo = "rec_type", comment = "收款单类型定义")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class RecTypeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "rec_type_code", columnDefinition = "varchar(32) comment '收款单类型代码'")
    private String recTypeCode;

    @Column(name = "rec_type_name", columnDefinition = "varchar(32) comment '收款单类型名称'")
    private String recTypeName;

    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;

    @Column(name = "default_flag", columnDefinition = "tinyint(1) comment '默认'")
    private Boolean defaultFlag;

    @Column(name = "auto_audit", columnDefinition = "tinyint(1) comment '自动审核'")
    private Boolean autoAudit;
}
