package com.elitesland.fin.entity.account;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author sunxw
 * @description
 * @Date 2023/5/30
 */
@Entity
@Table(name = "account_storage_detail", indexes = {
        @Index(name = "idx_storage_id",columnList = "storage_id",unique = false),
        @Index(name = "idx_refund_order_id",columnList = "refund_order_id",unique = false)
})
@org.hibernate.annotations.Table(appliesTo = "account_storage_detail", comment = "账户储值明细表")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class AccountStorageDetailDO extends BaseModel {

    @Column(name = "storage_id",columnDefinition = "bigint(20) comment '储值单号'")
    private Long storageId;

    @Column(name = "remitter_date",columnDefinition = "datetime(6) comment '支付日期'")
    private LocalDate remitterDate;

    @Column(name = "refund_date",columnDefinition = "datetime(6) comment '退款日期'")
    private LocalDate refundDate;

    @Column(name = "refund_order_id",columnDefinition = "varchar(32) comment '退款流水号'")
    private String refundOrderId;

    @Column(name = "refund_amt",columnDefinition = "decimal(18,8) comment '退款金额'")
    private BigDecimal refundAmt;

    @Column(name = "refund_reason",columnDefinition = "varchar(128) comment '退款原因'")
    private String refundReason;

    @Column(name = "abstract_info",columnDefinition = "varchar(256) comment '银联退款返回摘要'")
    private String abstractInfo;

    @Column(name = "ori_msg", columnDefinition = "varchar(1024) comment '退款原始报文'")
    private String oriMsg;

}
