package com.elitesland.fin.infinity.aisino.service;


import com.elitesland.fin.infinity.aisino.vo.param.AisinoApplyPayload;
import com.elitesland.fin.infinity.aisino.vo.param.notice.InvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoApplyRespVO;

import static com.elitesland.fin.infinity.aisino.domain.AisinoRouterCode.XF_BIZ_ORDER_INVOICE;
import static com.elitesland.fin.infinity.aisino.domain.AisinoRouterCode.XF_BIZ_SYNC_RESULT;

/**
 * @author eric.hao
 * @since 2023/05/16
 */
public interface AisinoService {

    /**
     * 记录 销项发票协同接口 参数日志
     *
     * @param param 参数
     */
    default void invoiceLog(String param) {
        addLog(XF_BIZ_ORDER_INVOICE, "销项发票协同接口", param);
    }

    /**
     * 记录 自动开具结果反馈接口 参数日志
     *
     * @param param 参数
     */
    default void noticeLog(String param) {
        addLog(XF_BIZ_SYNC_RESULT, "自动开具结果反馈接口", param);
    }

    /**
     * 记录票易通参数日志
     *
     * @param type  场景类型
     * @param name  场景名称
     * @param param 场景入参
     */
    void addLog(String type, String name, String param);

    /**
     * 业务单上传接口
     *
     * @param payload 上传参数
     * @return 接口返回结果
     */
    AisinoApplyRespVO orderUploadApply(AisinoApplyPayload payload);


    /**
     * 红票确认单初始化
     *
     * @param payload
     * @return
     */
    AisinoApplyRespVO orderRedInitial(AisinoApplyPayload payload);


    /**
     * 红票确认单保存
     *
     * @param payload
     * @return
     */
    AisinoApplyRespVO orderRedSave(AisinoApplyPayload payload);


    /**
     * 红票开具
     *
     * @param payload
     * @return
     */
    AisinoApplyRespVO orderRedOpen(AisinoApplyPayload payload);
    /**
     * 销项发票协同接口 (票易通 -> FOS)
     *
     * @param invoiceParam 发票参数
     */
    void saveInvoice(InvoiceParam invoiceParam);
//
//    /**
//     * 根据单号 查询业务单据内容
//     *
//     * @param applyNo 开票申请单号
//     * @return 业务单据信息
//     */
//    OrderQueryRespVO queryBizOrder(String applyNo);
//
//    /**
//     * 根据单号 查询票易通发票
//     *
//     * @param applyNo 开票申请单号
//     * @return 发票信息
//     */
//    InvoiceParam queryInvoice(String applyNo);
}
