package com.elitesland.fin.infinity.aisino.service;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infinity.aisino.entity.AisinoLogDO;
import com.elitesland.fin.infinity.aisino.enums.RedStateEnum;
import com.elitesland.fin.infinity.aisino.repo.AisinoLogRepo;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoApplyPayload;
import com.elitesland.fin.infinity.aisino.vo.param.invoice.InvoiceMain;
import com.elitesland.fin.infinity.aisino.vo.param.notice.InvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRespVO;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoApplyRespVO;
import com.elitesland.fin.infinity.http.RestClient;
import com.elitesland.fin.infinity.http.param.HttpParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceSaveParam;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import static com.elitesland.fin.infinity.aisino.domain.AisinoRouterCode.XF_BIZ_ORDER_UPLOAD;
import static java.time.LocalDateTime.parse;

/**
 * @author eric.hao
 * @since 2023/05/16
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class AisinoServiceImpl implements AisinoService {

    //    private final RouterClientService routerClientService;
    private final RestClient restClient;
    private final AisinoLogRepo aisinoLogRepo;
    //    private final PaymentRecordsService paymentRecordsService;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final TaskExecutor taskExecutor;
    @Autowired
    @Lazy
    private InvoiceAwaitService invoiceAwaitService;
    @Autowired
    private InvoiceRedraftRepo invoiceRedraftRepo;
//    @Autowired
//    private InvoiceSaveService invoiceSaveService;
    private final InvoiceApplyService invoiceApplyService;

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Exception.class)
    @Override
    public void addLog(String type, String name, String param) {
        AisinoLogDO xforceLog = new AisinoLogDO();
        xforceLog.setRequestType(type);
        xforceLog.setRequestTypeName(name);
        xforceLog.setRequestParam(param);
        aisinoLogRepo.save(xforceLog);
    }

    @SneakyThrows
    @Override
    public AisinoApplyRespVO orderUploadApply(AisinoApplyPayload payload) {
        // 构建接口相关参数
//        InfinityRouterParamVO routerParam = AisinoRouterVO.of(XF_BIZ_ORDER_UPLOAD);
        // 构建接口入参
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload);
        String url = "http://IP:port/openapi/qd/qpt/Kp_Fpkj";

        HttpParam<AisinoRespVO, AisinoRespVO> param = new HttpParam<>();
        param.setUrl(url);
        param.setBody(requestBody);
        param.setRequestMethod(RequestMethod.POST);
        addLog(XF_BIZ_ORDER_UPLOAD, "业务单上传接口：参数", BeanUtils.toJsonStr(requestBody));
        String exchange = restClient.exchange(param);
        addLog(XF_BIZ_ORDER_UPLOAD, "业务单上传接口：结果", BeanUtils.toJsonStr(exchange));
        AisinoRespVO responseVO = AisinoRespVO.convertResult(exchange);
        log.info("[AISINO] response: {}", responseVO);
        log.info("是否提交成功：{}", AisinoRespVO.success(responseVO));
        Object result = responseVO.getResult();
        AisinoApplyRespVO aisinoApplyRespVO = BeanUtils.toBean(result, AisinoApplyRespVO.class);
        log.info("[AISINO] blueApplyRespVO: {}", aisinoApplyRespVO);
        return aisinoApplyRespVO;
    }

    @Override
    public AisinoApplyRespVO orderRedInitial(AisinoApplyPayload payload) {
        // 构建接口相关参数
//        InfinityRouterParamVO routerParam = AisinoRouterVO.of(XF_BIZ_ORDER_UPLOAD);
        // 构建接口入参
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload);
        String url = "http://IP:port/openapi/qd/qpt/Kp_Fpkj";

        HttpParam<AisinoRespVO, AisinoRespVO> param = new HttpParam<>();
        param.setUrl(url);
        param.setBody(requestBody);
        param.setRequestMethod(RequestMethod.POST);
        addLog(XF_BIZ_ORDER_UPLOAD, "业务单上传接口：参数", BeanUtils.toJsonStr(requestBody));
        String exchange = restClient.exchange(param);
        addLog(XF_BIZ_ORDER_UPLOAD, "业务单上传接口：结果", BeanUtils.toJsonStr(exchange));
        AisinoRespVO responseVO = AisinoRespVO.convertResult(exchange);
        log.info("[AISINO] response: {}", responseVO);
        log.info("是否提交成功：{}", AisinoRespVO.success(responseVO));
        Object result = responseVO.getResult();
        AisinoApplyRespVO aisinoApplyRespVO = BeanUtils.toBean(result, AisinoApplyRespVO.class);
        log.info("[AISINO] blueApplyRespVO: {}", aisinoApplyRespVO);
        return aisinoApplyRespVO;
    }

    @Override
    public AisinoApplyRespVO orderRedSave(AisinoApplyPayload payload) {
        // 构建接口相关参数
//        InfinityRouterParamVO routerParam = AisinoRouterVO.of(XF_BIZ_ORDER_UPLOAD);
        // 构建接口入参
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload);
        String url = "http://IP:port/openapi/qd/qpt/Kp_Fpkj";

        HttpParam<AisinoRespVO, AisinoRespVO> param = new HttpParam<>();
        param.setUrl(url);
        param.setBody(requestBody);
        param.setRequestMethod(RequestMethod.POST);
        addLog(XF_BIZ_ORDER_UPLOAD, "业务单上传接口：参数", BeanUtils.toJsonStr(requestBody));
        String exchange = restClient.exchange(param);
        addLog(XF_BIZ_ORDER_UPLOAD, "业务单上传接口：结果", BeanUtils.toJsonStr(exchange));
        AisinoRespVO responseVO = AisinoRespVO.convertResult(exchange);
        log.info("[AISINO] response: {}", responseVO);
        log.info("是否提交成功：{}", AisinoRespVO.success(responseVO));
        Object result = responseVO.getResult();
        AisinoApplyRespVO aisinoApplyRespVO = BeanUtils.toBean(result, AisinoApplyRespVO.class);
        log.info("[AISINO] blueApplyRespVO: {}", aisinoApplyRespVO);
        return aisinoApplyRespVO;
    }

    @Override
    public AisinoApplyRespVO orderRedOpen(AisinoApplyPayload payload) {
        // 构建接口相关参数
//        InfinityRouterParamVO routerParam = AisinoRouterVO.of(XF_BIZ_ORDER_UPLOAD);
        // 构建接口入参
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload);
        String url = "http://IP:port/openapi/qd/qpt/Kp_Fpkj";

        HttpParam<AisinoRespVO, AisinoRespVO> param = new HttpParam<>();
        param.setUrl(url);
        param.setBody(requestBody);
        param.setRequestMethod(RequestMethod.POST);
        addLog(XF_BIZ_ORDER_UPLOAD, "业务单上传接口：参数", BeanUtils.toJsonStr(requestBody));
        String exchange = restClient.exchange(param);
        addLog(XF_BIZ_ORDER_UPLOAD, "业务单上传接口：结果", BeanUtils.toJsonStr(exchange));
        AisinoRespVO responseVO = AisinoRespVO.convertResult(exchange);
        log.info("[AISINO] response: {}", responseVO);
        log.info("是否提交成功：{}", AisinoRespVO.success(responseVO));
        Object result = responseVO.getResult();
        AisinoApplyRespVO aisinoApplyRespVO = BeanUtils.toBean(result, AisinoApplyRespVO.class);
        log.info("[AISINO] blueApplyRespVO: {}", aisinoApplyRespVO);
        return aisinoApplyRespVO;
    }

    @Override
    public void saveInvoice(InvoiceParam invoiceParam) {
        List<InvoiceSaveParam> saveParams = new ArrayList<>();
        InvoiceMain invoiceMain = invoiceParam.getInvoiceMain();
        // 开票申请单号
        InvoiceApplyRpcDTO applyRpcDTO = invoiceApplyService.queryIdByApplyNo(invoiceMain.getSalesbillNo());
        Assert.notNull(applyRpcDTO.getApplyId(), invoiceMain.getSalesbillNo() + " 单据不存在");
        InvoiceSaveParam saveParam = new InvoiceSaveParam();
        // 开票申请表头id
        saveParam.setMasId(applyRpcDTO.getApplyId());
        // 发票号码
        saveParam.setInvNo(invoiceMain.getInvoiceNo());
        // 发票代码
        saveParam.setInvCode(invoiceMain.getInvoiceCode());
        // 流水号
        saveParam.setFlowNo(invoiceMain.getBatchNo());
        // 校验码
        saveParam.setCheckCode(invoiceMain.getCheckCode());
        // 原蓝票代码
        saveParam.setBlueInvCode(invoiceMain.getOriginInvoiceCode());
        // 原蓝票号码
        saveParam.setBlueInvNo(invoiceMain.getOriginInvoiceNo());
        // 开票金额
        saveParam.setTotalAmt(new BigDecimal(invoiceMain.getAmountWithTax()));
        // 开票日期
        saveParam.setInvDate(parse(invoiceMain.getPaperDrewDate()));
        // 红冲状态
        saveParam.setRedState(invoiceMain.getRedStatus());
        // 开票状态
        saveParam.setInvState(invoiceMain.getStatus());
        // pdf链接
        saveParam.setInvPdfUrl(invoiceMain.getPdfPath());
        // 开票失败原因
        saveParam.setInvFailCause("");
        saveParams.add(saveParam);
        invoiceApplyService.saveInvoice(saveParams);

        // 异步处理后续操作
        CompletableFuture.runAsync(() -> handleOutcomeOfInvoice(invoiceMain, applyRpcDTO), taskExecutor);
    }

    /**
     * 根据票易通的开票状态和红冲状态，处理后续流程，开票申请单和修改订货单状态
     *
     * @param invoiceMain 票易通开票主数据
     * @param applyRpcDTO 原开票申请单
     */
    private void handleOutcomeOfInvoice(InvoiceMain invoiceMain, InvoiceApplyRpcDTO applyRpcDTO) {
        log.info("开始确认关联单据状态,开票状态:{},红冲状态:{},开票申请单入参:{}", invoiceMain.getStatus(), invoiceMain.getRedStatus(), JSON.toJSONString(applyRpcDTO));
        List<String> sourceDocNoList = applyRpcDTO.getPaymentNoList();
        //订单红冲
        if (RedStateEnum.RED_PUNCH.getCode().equals(invoiceMain.getRedStatus())) {
            //重新生成付款记录并初始化订货单开票状态
            SaleInvDO saleInvDO = saleInvRepo.findByApplyNo(invoiceMain.getSalesbillNo());
            if (!Objects.isNull(saleInvDO)) {
                log.error("未找到开票申请单，单号为：{}", invoiceMain.getSalesbillNo());
            }
            // 查询开票申请单明细
            List<SaleInvDtlDTO> saleInvDtlDTOList = saleInvDtlRepoProc.getList(saleInvDO.getId());

            List<Long> salInvDtlIdList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(saleInvDtlDTOList)) {
                salInvDtlIdList = saleInvDtlDTOList.stream().map(SaleInvDtlDTO::getSourceLineId).collect(Collectors.toList());
            }

            //获取流程的审批状态
            InvoiceRedraftDO invoiceRedraftDO = invoiceRedraftRepo.findByOrigApplyNo(invoiceMain.getSalesbillNo());
            //红冲完成且审批通过生成开票申请单
            if (!ObjectUtils.isEmpty(invoiceRedraftDO) && ProcInstStatus.APPROVED.equals(invoiceRedraftDO.getWorkflowProcInstStatus()) && ObjectUtils.isEmpty(invoiceRedraftDO.getOrigApplyNo())) {
                log.info("红冲后开始创建新的开票申请单");
                createInvoice(applyRpcDTO, saleInvDO, salInvDtlIdList, invoiceRedraftDO);
            }
        }
//        else if (RedStateEnum.PRE_RED_PUNCH.getCode().equals(invoiceMain.getRedStatus())) {
//            //订货单状态更新为开票成功
//            paymentRecordsService.updateInvoiceRelatedOrderStatus(sourceDocNoList, "30");
//        } else if (RedStateEnum.DEFAULT.getCode().equals(invoiceMain.getRedStatus())) {
//            //订货单状态更新为开票失败
//            paymentRecordsService.updateInvoiceRelatedOrderStatus(sourceDocNoList, "50");
//        }
    }

    /**
     * 开始重新开票
     *
     * @param applyRpcDTO      原开票申请单数据
     * @param saleInvDO        原开票数据
     * @param invoiceRedraftDO 开票审批流程数据
     */
    private void createInvoice(InvoiceApplyRpcDTO applyRpcDTO, SaleInvDO saleInvDO, List<Long> paymentRecordDetailIdList, InvoiceRedraftDO invoiceRedraftDO) {
        InvoiceApplyParam param = new InvoiceApplyParam();
        param.setOptDocNos(applyRpcDTO.getPaymentNoList());
        param.setIds(applyRpcDTO.getPaymentIds());
        if (!CollectionUtils.isEmpty(paymentRecordDetailIdList)) {
            param.setBizDtlKey(paymentRecordDetailIdList);
        }
//        if (!Objects.isNull(invoiceRedraftDO.getSaleTaxNo())) {
//            param.setCustTaxNo(invoiceRedraftDO.getSaleTaxNo());
//            param.setCustInvTitle(invoiceRedraftDO.getSaleInvTitle());
//            param.setAddress(invoiceRedraftDO.getSaleAdd());
//            param.setCustBank(invoiceRedraftDO.getSaleBank());
//            param.setCustBankAcc(invoiceRedraftDO.getSaleBankAcc());
//            param.setCustTel(invoiceRedraftDO.getSaleTel());
//        } else {
        param.setCustTaxNo(saleInvDO.getCustTaxNo());
        param.setCustInvTitle(saleInvDO.getCustInvTitle());
        param.setAddress(saleInvDO.getCustAdd());
        param.setCustBank(saleInvDO.getCustBank());
        param.setCustBankAcc(saleInvDO.getCustBankAcc());
        param.setCustTel(saleInvDO.getCustTel());
//        }
        param.setInvType(invoiceRedraftDO.getInvoiceType());
        log.info("开始生成开票申请单，入参为：{}", JSON.toJSONString(param));
        List<InvoiceSaveVO> saveList = invoiceAwaitService.invoiceApply(param);
        log.info("保存开票申请单返回结果为：{}", JSON.toJSONString(saveList));
        // 回填新的开票号
        if (!CollectionUtils.isEmpty(saveList)) {
            for (InvoiceSaveVO save : saveList) {
                if (!Objects.isNull(save.getApplyNo()))
                    log.info("开始执行更新新申请单号更新语句，数据为{},id:{}", save.getApplyNo(), invoiceRedraftDO.getId());
                JPAUpdateClause update = jpaQueryFactory.update(qdo)
                        .set(qdo.redraftApplyNo, save.getApplyNo())
                        .where(qdo.id.eq(invoiceRedraftDO.getId()));
                log.info("打印执行语句");
                update.execute();
            }
        }
    }

//    @Override
//    public OrderQueryRespVO queryBizOrder(String applyNo) {
//        // 构建接口相关参数
//        InfinityRouterParamVO routerParam = XforceRouterVO.of(XF_BIZ_ORDER_QUERY);
//        // 构建接口入参
//        Map<String, Object> requestBody = new HashMap<>();
//        requestBody.put("bizOrderNo", applyNo);
//        requestBody.put("serialNo", applyNo);
//        requestBody.put("accountType", "AR");
//        requestBody.put("includeDetails", true);
//        addLog(XF_BIZ_ORDER_QUERY, "业务单单张查询接口：参数", BeanUtils.toJsonStr(requestBody));
//        XforceRespVO responseVO = routerClientService.send(routerParam, requestBody, XforceRespVO.class);
//        addLog(XF_BIZ_ORDER_QUERY, "业务单单张查询接口：结果", BeanUtils.toJsonStr(responseVO));
//        if (ResponseVO.failed(responseVO)) {
//            throw new BusinessException("查询失败：[票易通] " + responseVO.getMessage());
//        }
//        return BeanUtils.toBean(responseVO.getResult(), OrderQueryRespVO.class);
//    }

//    @SneakyThrows
//    @Override
//    public InvoiceParam queryInvoice(String applyNo) {
//        // 构建接口相关参数
//        InfinityRouterParamVO routerParam = XforceRouterVO.of(XF_BIZ_INVOICE_QUERY);
//        // 构建接口入参
//        String requestStr = "{\"conditions\": [{\"conditionOP\": \"eq\",\"field\": \"bizOrderNo\",\"value\": \"" + applyNo + "\",\"values\": []}],\"page\": {\"pageNo\": 1,\"pageSize\": 10},\"sorts\": [{\"field\": \"invoiceNo\",\"value\": \"asc\"}]}";
//        Map<String, Object> requestBody = BeanUtils.toMap(requestStr);
//        requestBody.put("serialNo", applyNo);
//        addLog(XF_BIZ_INVOICE_QUERY, "销项发票查询：参数", requestStr);
//        XforceRespVO responseVO = routerClientService.send(routerParam, requestBody, XforceRespVO.class);
//        addLog(XF_BIZ_INVOICE_QUERY, "销项发票查询：结果", BeanUtils.toJsonStr(responseVO));
//        if (ResponseVO.failed(responseVO)) {
//            throw new BusinessException("查询失败：[票易通] " + responseVO.getMessage());
//        }
//
//        InvoiceQueryRespVO invoiceResp = BeanUtils.toBean(responseVO.getResult(), InvoiceQueryRespVO.class);
//        List<InvoiceQueryData> result = BeanUtils.toList(invoiceResp.getData(), InvoiceQueryData.class);
//        if (CollUtil.isEmpty(result)) {
//            throw new BusinessException("查询失败：[票易通] 未查到任何可用单据");
//        }
//        if (CollUtil.isNotEmpty(result)) {
//            InvoiceParam invoiceParam = new InvoiceParam();
//            InvoiceMain invoiceMain = XforceConvert.INSTANCE.queryToMain(result.get(0));
//            invoiceMain.setSalesbillNo(applyNo);
//            invoiceParam.setInvoiceMain(invoiceMain);
//            return invoiceParam;
//        }
//        return null;
//    }

//    private LocalDateTime parse(String date) {
//        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");
//        return LocalDateTime.parse(date + " 00:00:00", formatter);
//    }
}
